/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.Level;

public class SrLoggerTest
extends TestCase {
    private Method createStringWithExceptionMethod;
    private Method createStringMethod;

    public SrLoggerTest() {
        Class<SrLogger> myClass = SrLogger.class;
        try {
            Class[] paramsForException = new Class[]{SrLogCategories.class, Throwable.class, Object[].class};
            this.createStringWithExceptionMethod = myClass.getDeclaredMethod("createString", paramsForException);
            this.createStringWithExceptionMethod.setAccessible(true);
            Class[] paramsForNoException = new Class[]{SrLogCategories.class, Object[].class};
            this.createStringMethod = myClass.getDeclaredMethod("createString", paramsForNoException);
            this.createStringMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            SrLoggerTest.fail((String)"Could not initialize the test.");
        }
        catch (NoSuchMethodException e) {
            SrLoggerTest.fail((String)"Could not initialize the test.");
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        Properties logProps = new Properties();
        logProps.put("zip.file.number", "50");
        logProps.put("zip.contain.number", "10");
        logProps.put("log4j.logger.com.sanrad.log", "DEBUG, DEBUG_APP");
        logProps.put("log4j.logger.sun.reflect", "DEBUG, DEBUG_APP");
        logProps.put("log4j.appender.DEBUG_APP.File", "${user.home}\\NMS_Tests\\test.log");
        logProps.put("log4j.appender.DEBUG_APP", "com.sanrad.log.SrRollingFileAppender");
        logProps.put("log4j.appender.DEBUG_APP.layout", "org.apache.log4j.PatternLayout");
        logProps.put("log4j.appender.DEBUG_APP.layout.ConversionPattern", "%d{dd MMM yyyy HH\\:mm\\:ss,SSS}|%p|%t|%m%n");
        logProps.put("log4j.appender.DEBUG_APP.MaxBackupIndex", "20");
        logProps.put("log4j.appender.DEBUG_APP.MaxFileSize", "24KB");
        try {
            SrLogger.reInit(logProps);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateArrayString() {
        SrLogger curLog = SrLogger.getLogger();
        int[] intArray = new int[]{1, 2, 3, 4, 5};
        Object[] moreArgs = new Object[]{"Testing ", intArray};
        Object[] args = new Object[]{SrLogCategories.ERROR, null, moreArgs};
        String retVal = null;
        try {
            retVal = (String)this.createStringWithExceptionMethod.invoke((Object)curLog, args);
        }
        catch (SecurityException e) {
            SrLoggerTest.fail();
        }
        catch (IllegalArgumentException e) {
            SrLoggerTest.fail();
        }
        catch (IllegalAccessException e) {
            SrLoggerTest.fail();
        }
        catch (InvocationTargetException e) {
            SrLoggerTest.fail();
        }
        String expected = "NativeMethodAccessorImpl.invoke0|ERROR|Testing " + Arrays.toString(intArray);
        SrLoggerTest.assertEquals((String)("The return value should be '" + expected + "' but it is: " + retVal), (String)expected, (String)retVal);
    }

    public void testCreateDeepArrayString() {
        SrLogger curLog = SrLogger.getLogger();
        int[] intArray = new int[]{1, 2, 3, 4, 5};
        int[][] intDeepArray = new int[][]{{1}, {2, 3}, {4, 5}};
        Object[] moreArgs = new Object[]{"Testing ", intArray, "; ", intDeepArray};
        Object[] args = new Object[]{SrLogCategories.ERROR, moreArgs};
        String retVal = null;
        try {
            retVal = (String)this.createStringMethod.invoke((Object)curLog, args);
        }
        catch (SecurityException e) {
            SrLoggerTest.fail();
        }
        catch (IllegalArgumentException e) {
            SrLoggerTest.fail();
        }
        catch (IllegalAccessException e) {
            SrLoggerTest.fail();
        }
        catch (InvocationTargetException e) {
            SrLoggerTest.fail();
        }
        String expected = "NativeMethodAccessorImpl.invoke0|ERROR|Testing " + Arrays.toString(intArray) + "; " + Arrays.deepToString((Object[])intDeepArray);
        SrLoggerTest.assertEquals((String)("The return value should be '" + expected + "' but it is: " + retVal), (String)expected, (String)retVal);
    }

    public void testErrorLoggingLevel() {
        SrLogger curLog = SrLogger.getLogger();
        curLog.setLevel(Level.ALL);
        long oldSize = this.getFileSize("NMS_Tests\\test.log");
        curLog.error(SrLogCategories.INFORMATIVE, "Testing");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException exp) {
            SrLoggerTest.fail((String)"The test was interrupted");
        }
        SrLoggerTest.assertTrue((String)"The new file size should be bigger than the old file size", (oldSize < this.getFileSize("NMS_Tests\\test.log") ? 1 : 0) != 0);
        curLog.setLevel(Level.OFF);
        oldSize = this.getFileSize("NMS_Tests\\test.log");
        curLog.error(SrLogCategories.INFORMATIVE, "Testing");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException exp) {
            SrLoggerTest.fail((String)"The test was interrupted");
        }
        SrLoggerTest.assertEquals((String)"The new file size should be the same as the old file size", (long)oldSize, (long)this.getFileSize("NMS_Tests\\test.log"));
    }

    public void testSystemCategory() {
        SrLogger curLog = SrLogger.getLogger();
        curLog.setLevel(Level.OFF);
        long oldSize = this.getFileSize("NMS_Tests\\test.log");
        Level oldLevel = curLog.getLevel();
        curLog.error(SrLogCategories.SYSTEM, "Testing");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException exp) {
            SrLoggerTest.fail((String)"The test was interrupted");
        }
        SrLoggerTest.assertTrue((String)"The new file size should be bigger than the old file size", (oldSize < this.getFileSize("NMS_Tests\\test.log") ? 1 : 0) != 0);
        SrLoggerTest.assertEquals((String)"The logging level should not change.", (Object)oldLevel, (Object)curLog.getLevel());
    }

    public void testZipFiles() {
        SrLogger curLog = SrLogger.getLogger();
        int zipFiles = this.getNumberOfZipFiles("NMS_Tests\\test.log");
        for (int index = 0; index < 10000; ++index) {
            curLog.error(SrLogCategories.SYSTEM, "Testing number " + index);
        }
        SrLoggerTest.assertNotSame((String)"A new zip file should have been created.", (Object)zipFiles, (Object)this.getNumberOfZipFiles("NMS_Tests\\test.log"));
    }

    private long getFileSize(String aFileName) {
        if (aFileName == null || aFileName.equals("")) {
            return 0L;
        }
        String userHome = System.getProperty("user.home");
        File curFile = new File(userHome + "\\" + aFileName);
        if (curFile.exists()) {
            return curFile.length();
        }
        return 0L;
    }

    private int getNumberOfZipFiles(String aFileName) {
        File[] files;
        if (aFileName == null || aFileName.equals("")) {
            return 0;
        }
        String zipDirName = System.getProperty("user.home");
        String zipFileName = aFileName;
        if (aFileName.contains("\\") || aFileName.contains("/")) {
            int lastIndex = aFileName.lastIndexOf("/");
            if (aFileName.lastIndexOf("\\") > lastIndex) {
                lastIndex = aFileName.lastIndexOf("\\");
            }
            zipDirName = zipDirName + "\\" + aFileName.substring(0, lastIndex);
            zipFileName = aFileName.substring(lastIndex);
        }
        if (zipFileName.lastIndexOf(".") > -1) {
            zipFileName = zipFileName.substring(0, zipFileName.lastIndexOf("."));
        }
        while (zipFileName.startsWith("\\") || zipFileName.startsWith("/")) {
            zipFileName = zipFileName.substring(1);
        }
        File zipDir = new File(zipDirName);
        if (!zipDir.isDirectory()) {
            return 0;
        }
        int retCount = 0;
        for (File curFile : files = zipDir.listFiles()) {
            if (!curFile.getName().startsWith(zipFileName) || !curFile.getName().endsWith(".zip")) continue;
            ++retCount;
        }
        return retCount;
    }

    public void testLogAndAssert1() {
        SrLogger curLog = SrLogger.getLogger();
        try {
            curLog.logAndAssert(SrLogCategories.ERROR, false, new Exception(), "test me");
        }
        catch (AssertionError ae) {
            SrLoggerTest.assertTrue((boolean)true);
            return;
        }
        SrLoggerTest.fail();
    }

    public void testLogAndAssert2() {
        SrLogger curLog = SrLogger.getLogger();
        try {
            curLog.logAndAssert(SrLogCategories.ERROR, false, new Object[]{"1. ", "test me"});
        }
        catch (AssertionError ae) {
            SrLoggerTest.assertTrue((boolean)true);
            return;
        }
        SrLoggerTest.fail();
    }
}

