/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.DebugLogObject;
import com.sanrad.log.LoggerStream;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLoggingException;
import com.sanrad.log.SrRollingFileAppender;
import com.sanrad.nms.server.comm.log.SrMonfoxProvider;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class SrLogger {
    private static final String DEBUG_STRING = "NORMAL";
    private static final String INVALID_STRING = "INVALID";
    private static boolean theIsConsole = false;
    private static final String REDIRECT_CONSOLE_ATTR = "redirect.console";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String APPENDER_MATCHING_STR = "log4j.appender.(\\S)*.File";
    private static final String DEBUG_APP_FILE = "log4j.appender.DEBUG_APP.File";
    private static final String DEBUG_APP = "log4j.appender.DEBUG_APP";
    private static final String APP_VAL = "com.sanrad.log.SrRollingFileAppender";
    private static final String DEBUG_APP_LAYOUT = "log4j.appender.DEBUG_APP.layout";
    private static final String APP_LAYOUT_VAL = "org.apache.log4j.PatternLayout";
    private static final String DEBUG_APP_CONV = "log4j.appender.DEBUG_APP.layout.ConversionPattern";
    private static final String APP_CONV_VAL = "%d{dd MMM yyyy HH\\:mm\\:ss,SSS}|%p|%t|%m%n";
    private static final String DEBUG_APP_MAX_INDEX = "log4j.appender.DEBUG_APP.MaxBackupIndex";
    private static final String APP_MAX_INDEX_VAL = "10";
    private static final String DEBUG_APP_MAX_FILE_SIZE = "log4j.appender.DEBUG_APP.MaxFileSize";
    private static final String APP_MAX_FILE_SIZE_VAL = "10MB";
    private static final String EXP_APP_FILE = "log4j.appender.EXP_APP.File";
    private static final String EXP_APP = "log4j.appender.EXP_APP";
    private static final String EXP_APP_LAYOUT = "log4j.appender.EXP_APP.layout";
    private static final String EXP_APP_CONV = "log4j.appender.EXP_APP.layout.ConversionPattern";
    private static final String EXP_APP_MAX_INDEX = "log4j.appender.EXP_APP.MaxBackupIndex";
    private static final String EXP_APP_MAX_FILE_SIZE = "log4j.appender.EXP_APP.MaxFileSize";
    private static final String EXP_FILE_NAME = "exceptions.log";
    private static final String REDIRECT_CONSOLE = "redirect.console";
    private static final String REDIRECT_CONSOLE_VAL = "false";
    private static final String ZIP_FILE_NUMBER = "zip.file.number";
    private static final String ZIP_FILE_NUMBER_VAL = "70";
    private static final String ZIP_CONTAIN_NUMBER = "zip.contain.number";
    private static final String ZIP_CONTAIN_NUMBER_VAL = "7";
    private static final String LOG4J_LOGGER_VAL = "DEBUG, DEBUG_APP";
    private static final String LOGGER_EXCEPTIONS = "log4j.logger.exceptions";
    private static final String LOGGER_EXCEPTIONS_VAL = "DEBUG, EXP_APP";
    private static List<Level> theLoggingLevels = new ArrayList<Level>();
    private static boolean isInit = false;
    private static final String SERVER_PREFIX = "com.sanrad.nms.server";
    private static final String CLIENT_PREFIX = "com.sanrad.nms.client";
    private static final String CLI_PREFIX = "com.sanrad.nms.cli";
    private static final String MONFOX_PREFIX = "com.sanrad.1monfox";
    private static final String EXTERNAL_PKG_PREFIX = "external";
    private static final String USER_PREFIX = "user";
    private static final String CONSOLE_PREFIX = "console";
    private static final String LOGIC_PREFIX = "com.sanrad.nms.server.logic";
    private static final String MODEL_PREFIX = "com.sanrad.nms.client.model";
    private static final String DATA_MGR_PREFIX = "com.sanrad.nms.server.mgr";
    private static final String GUI_PREFIX = "com.sanrad.nms.client.gui";
    private static final String TRAP_LOG_NAME = "trap";
    private static final String EXCEPTIONS_LOG_NAME = "exceptions";
    private static boolean theShowPackageName = false;
    private static final String SERVER_PROPERTY = "log4j.logger.com.sanrad.nms.server";
    private static final String CLIENT_PROPERTY = "log4j.logger.com.sanrad.nms.client";
    private static final String CLI_PROPERTY = "log4j.logger.com.sanrad.nms.cli";
    private static final String MONFOX_PROPERTY = "log4j.logger.com.sanrad.1monfox";
    private static int theZipFilesNumber = 10;
    private static int theLogFilesInZipNumber = 5;
    private static final String ZIP_FILES_NUM_PARAM = "zip.file.number";
    private static final String LOG_FILES_IN_ZIP_NUM_PARAM = "zip.contain.number";
    private static final String FIELD_DELIMITER = "|";
    private static final String DUMMY_CTOR_MSG = "Error while creating a logger for class: ";
    private static final String USER_LOG_RQST_BY_NON_LOGIC = "The user log can only be used by logic layer classes, but the requesting class is: ";
    private Logger myLogger;
    private Logger myExceptionLogger;

    private static synchronized boolean isInit() {
        return isInit;
    }

    private static synchronized void setIsInit(boolean aIsInit) {
        isInit = aIsInit;
    }

    public static List<Level> getLogLevels() {
        return theLoggingLevels;
    }

    private static Properties getDefaultProperties(String aPackage, String aFileName, String aPath) {
        Properties retVal = new Properties();
        retVal.put(DEBUG_APP_FILE, aPath + "/" + aFileName);
        retVal.put(DEBUG_APP, APP_VAL);
        retVal.put(DEBUG_APP_LAYOUT, APP_LAYOUT_VAL);
        retVal.put(DEBUG_APP_CONV, APP_CONV_VAL);
        retVal.put(DEBUG_APP_MAX_INDEX, APP_MAX_INDEX_VAL);
        retVal.put(DEBUG_APP_MAX_FILE_SIZE, APP_MAX_FILE_SIZE_VAL);
        retVal.put(EXP_APP_FILE, aPath + "/" + EXP_FILE_NAME);
        retVal.put(EXP_APP, APP_VAL);
        retVal.put(EXP_APP_LAYOUT, APP_LAYOUT_VAL);
        retVal.put(EXP_APP_CONV, APP_CONV_VAL);
        retVal.put(EXP_APP_MAX_INDEX, APP_MAX_INDEX_VAL);
        retVal.put(EXP_APP_MAX_FILE_SIZE, APP_MAX_FILE_SIZE_VAL);
        retVal.put("redirect.console", REDIRECT_CONSOLE_VAL);
        retVal.put("zip.file.number", ZIP_FILE_NUMBER_VAL);
        retVal.put("zip.contain.number", ZIP_CONTAIN_NUMBER_VAL);
        retVal.put("log4j.logger." + aPackage, LOG4J_LOGGER_VAL);
        retVal.put(LOGGER_EXCEPTIONS, LOGGER_EXCEPTIONS_VAL);
        return retVal;
    }

    public static synchronized void reInit(Properties aProp) {
        SrLogger.setIsInit(false);
        LogManager.resetConfiguration();
        SrLogger.init(aProp);
    }

    public static boolean isServerProperties(Properties aProp) {
        if (aProp == null) {
            return false;
        }
        return aProp.containsKey(SERVER_PROPERTY);
    }

    public static boolean isClientProperties(Properties aProp) {
        if (aProp == null) {
            return false;
        }
        return aProp.containsKey(CLIENT_PROPERTY);
    }

    public static boolean isCliProperties(Properties aProp) {
        if (aProp == null) {
            return false;
        }
        return aProp.containsKey(CLI_PROPERTY);
    }

    public static String getMaxLengthLevel() {
        String retStr = INVALID_STRING;
        for (Level curLevel : theLoggingLevels) {
            if (curLevel.toString().length() <= retStr.length()) continue;
            retStr = curLevel.toString();
        }
        return retStr;
    }

    public static synchronized void initWithDefaultProperties(String aPackage, String aFileName, String aPath) {
        SrLogger.init(SrLogger.getDefaultProperties(aPackage, aFileName, aPath));
    }

    public static synchronized void init(Properties aProp) {
        if (aProp == null) {
            assert (false) : "The given properties should not be null.";
            return;
        }
        String redirect = aProp.getProperty("redirect.console");
        theIsConsole = Boolean.parseBoolean(redirect);
        if (SrLogger.isInit()) {
            String initMsg = "The logger has already been initialized. The current init properties: " + aProp + " are disregarded.";
            System.out.println(initMsg);
            assert (false) : initMsg;
            return;
        }
        theLoggingLevels = SrLogger.getLoggingLevels();
        try {
            theZipFilesNumber = Integer.parseInt(aProp.getProperty("zip.file.number"));
            theLogFilesInZipNumber = Integer.parseInt(aProp.getProperty("zip.contain.number"));
        }
        catch (NumberFormatException exp) {
            System.err.println("The zip configuration could not be read from the logging configuration file.");
        }
        SrLogger.renameOldFiles(aProp);
        try {
            PropertyConfigurator.configure((Properties)aProp);
        }
        catch (Throwable exp) {
            String errMsg = "Could not initialize the logger because of the following exception: " + exp.getMessage();
            System.err.println(errMsg);
            exp.printStackTrace();
            assert (false) : errMsg;
            return;
        }
        String snmpProp = aProp.getProperty(MONFOX_PROPERTY);
        if (snmpProp != null && !snmpProp.equals("")) {
            new SrMonfoxProvider();
        }
        try {
            SrLogger.zipAllLogs(SERVER_PREFIX);
            SrLogger.zipAllLogs(CLIENT_PREFIX);
            SrLogger.zipAllLogs(CLI_PREFIX);
            SrLogger.zipAllLogs(EXTERNAL_PKG_PREFIX);
            SrLogger.zipAllLogs(USER_PREFIX);
            SrLogger.zipAllLogs(CONSOLE_PREFIX);
            SrLogger.zipAllLogs(MONFOX_PREFIX);
            SrLogger.zipAllLogs(TRAP_LOG_NAME);
            SrLogger.zipAllLogs(EXCEPTIONS_LOG_NAME);
        }
        catch (SrLoggingException e) {
            System.err.println("Could not zip the log files.");
        }
        catch (IOException e) {
            System.err.println("Could not zip the log files.");
        }
        SrLogger.setAdditivity(SERVER_PREFIX, false);
        SrLogger.setAdditivity(CLIENT_PREFIX, false);
        SrLogger.setAdditivity(CLI_PREFIX, false);
        SrLogger.setAdditivity(EXTERNAL_PKG_PREFIX, false);
        SrLogger.setAdditivity(USER_PREFIX, false);
        SrLogger.setAdditivity(CONSOLE_PREFIX, false);
        SrLogger.setIsInit(true);
        if (!theIsConsole) {
            LoggerStream errConsoleStream = new LoggerStream(SrLogger.getConsoleLogger().myLogger);
            LoggerStream outConsoleStream = new LoggerStream(SrLogger.getConsoleLogger().myLogger);
            if (SrLogger.getConsoleLogger().myLogger != null && SrLogger.getConsoleLogger().getLevel() != null) {
                System.out.println("INFO: Redirecting the standard output and standard error to the log files.");
                System.err.close();
                System.out.close();
                System.setErr(errConsoleStream);
                System.setOut(outConsoleStream);
            }
        }
    }

    private static void renameOldFiles(Properties aProp) {
        for (Object curKey : aProp.keySet()) {
            String newName;
            if (!(curKey instanceof String)) {
                if (curKey == null) {
                    assert (false) : "The properties should not contain a null key.";
                    continue;
                }
                assert (false) : "The given properties should only contain strings but it contains a key which is a " + curKey.getClass() + ": " + curKey;
                continue;
            }
            String keyStr = (String)curKey;
            if (!keyStr.matches(APPENDER_MATCHING_STR)) continue;
            String fileName = aProp.getProperty(keyStr);
            if (fileName == null || fileName.equals("")) {
                assert (false) : "The file name for the appender " + keyStr + " should not be empty or null, but it is: " + fileName;
                continue;
            }
            if (!fileName.contains(".")) {
                newName = fileName + ".0";
            } else {
                String noExtension = fileName.substring(0, fileName.lastIndexOf("."));
                String extension = fileName.substring(fileName.lastIndexOf("."));
                newName = noExtension + ".0" + extension;
            }
            File oldFile = new File(fileName);
            if (oldFile.length() == 0L) continue;
            oldFile.renameTo(new File(newName));
        }
    }

    public static void zipAllLogs(String aLogName) throws IOException {
        SrLogger curLogger = SrLogger.getLog(aLogName);
        Enumeration appenders = curLogger.myLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender curApp = (Appender)appenders.nextElement();
            if (!(curApp instanceof SrRollingFileAppender)) continue;
            ((SrRollingFileAppender)curApp).zipAllFiles();
        }
    }

    public static int getNumOfZipFiles() {
        return theZipFilesNumber;
    }

    public static int getNumOfFilesInZip() {
        return theLogFilesInZipNumber;
    }

    public static SrLogger getDummyLogger() {
        return SrDummyLog.getInstance();
    }

    public static void loadConfiguration(String aCfgFileName) {
        PropertyConfigurator.configure((String)aCfgFileName);
    }

    private static void setAdditivity(String aLogName, boolean additivity) {
        if (aLogName == null) {
            assert (false) : "The log name should not be null.";
            return;
        }
        Logger baseLog = Logger.getLogger((String)aLogName);
        if (baseLog != null) {
            baseLog.setAdditivity(additivity);
        }
    }

    public static SrLogger getLogger() {
        if (!SrLogger.isInit()) {
            assert (false) : "The log was not initialized";
            return SrLogger.getDummyLogger();
        }
        String callingClass = SrLogger.getCallerClassName();
        return SrLogger.getLog(callingClass);
    }

    private static StackTraceElement getFirstNonLoggerFrame() {
        StackTraceElement[] curStack = Thread.currentThread().getStackTrace();
        for (int index = 2; index < curStack.length; ++index) {
            StackTraceElement curElem = curStack[index];
            if (curElem.getClassName().contains("SrLogger")) continue;
            return curElem;
        }
        assert (false) : "No non-logger stack trace element could be found in the stack trace: " + SrLogger.getThrowableOutput(new Exception());
        return curStack[curStack.length - 1];
    }

    public static String getThrowableOutput(Throwable aThr) {
        if (aThr == null) {
            assert (false) : "The given throwable is null.";
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        aThr.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static String getCallerClassName() {
        return SrLogger.getFirstNonLoggerFrame().getClassName();
    }

    private static String getCallerMethodName() {
        return SrLogger.getFirstNonLoggerFrame().getMethodName();
    }

    private static String getCallerClassAndMethodName() {
        String callerClass = SrLogger.getCallerClassName();
        String callerMethod = SrLogger.getCallerMethodName();
        if (!theShowPackageName) {
            String[] classParts = callerClass.split("\\.");
            callerClass = classParts[classParts.length - 1];
        }
        return callerClass + "." + callerMethod;
    }

    public static void setShowPackageName(boolean aVal) {
        theShowPackageName = aVal;
    }

    private static SrLogger getLog(String aLog) {
        Logger log4jLog = null;
        try {
            log4jLog = Logger.getLogger((String)aLog);
        }
        catch (NullPointerException exp) {
            System.err.println(DUMMY_CTOR_MSG + aLog);
            return SrLogger.getDummyLogger();
        }
        SrLogger retLogger = new SrLogger(log4jLog);
        return retLogger;
    }

    public static SrLogger getUserLogger() {
        if (!SrLogger.isInit()) {
            assert (false) : "The log was not initialized";
            return SrLogger.getDummyLogger();
        }
        String callingClass = SrLogger.getCallerClassName();
        if (callingClass.startsWith(LOGIC_PREFIX)) {
            return SrLogger.getLog("user." + callingClass);
        }
        assert (false) : "The user log can only be used by logic layer classes, but the requesting class is: " + callingClass;
        return SrLogger.getDummyLogger();
    }

    public static SrLogger getTrapLogger() {
        if (!SrLogger.isInit()) {
            assert (false) : "The log was not initialized";
            return SrLogger.getDummyLogger();
        }
        return SrLogger.getLog(TRAP_LOG_NAME);
    }

    public static SrLogger getConsoleLogger() {
        if (!SrLogger.isInit()) {
            assert (false) : "The log was not initialized";
            return SrLogger.getDummyLogger();
        }
        String callingClass = SrLogger.getCallerClassName();
        return SrLogger.getLog("console." + callingClass);
    }

    public static SrLogger getExternalPackageLogger() {
        if (!SrLogger.isInit()) {
            assert (false) : "The log was not initialized";
            return SrLogger.getDummyLogger();
        }
        String callingClass = SrLogger.getCallerClassName();
        return SrLogger.getLog("external." + callingClass);
    }

    public static void setLogicLoggingLevel(Level aLevel) {
        if (aLevel == null) {
            assert (false) : "The level should not be null.";
            return;
        }
        Logger log4jLog = Logger.getLogger((String)LOGIC_PREFIX);
        if (log4jLog != null) {
            log4jLog.setLevel(aLevel);
        }
    }

    public static void setModelLoggingLevel(Level aLevel) {
        if (aLevel == null) {
            assert (false) : "The level should not be null.";
            return;
        }
        Logger log4jLog = Logger.getLogger((String)MODEL_PREFIX);
        if (log4jLog != null) {
            log4jLog.setLevel(aLevel);
        }
    }

    public static void setDataMgrLoggingLevel(Level aLevel) {
        if (aLevel == null) {
            assert (false) : "The level should not be null.";
            return;
        }
        Logger log4jLog = Logger.getLogger((String)DATA_MGR_PREFIX);
        if (log4jLog != null) {
            log4jLog.setLevel(aLevel);
        }
    }

    public static void setGUILoggingLevel(Level aLevel) {
        if (aLevel == null) {
            assert (false) : "The level should not be null.";
            return;
        }
        Logger log4jLog = Logger.getLogger((String)GUI_PREFIX);
        if (log4jLog != null) {
            log4jLog.setLevel(aLevel);
        }
    }

    protected SrLogger(Logger aWrappedLogger) {
        if (aWrappedLogger == null && !(this instanceof SrDummyLog)) {
            throw new IllegalArgumentException("The given log4j logger should not be null, unless we are using a dummy logger.");
        }
        this.myLogger = aWrappedLogger;
        this.myExceptionLogger = Logger.getLogger((String)EXCEPTIONS_LOG_NAME);
    }

    public boolean isEnabledFor(Level aLevel) {
        if (aLevel == null) {
            assert (false) : "The level should not be null.";
            return false;
        }
        return this.myLogger.isEnabledFor((Priority)aLevel);
    }

    public void setLevel(Level aLevel) {
        if (aLevel == null) {
            assert (false) : "The level should not be null.";
            return;
        }
        this.myLogger.setLevel(aLevel);
    }

    public Level getLevel() {
        return this.myLogger.getLevel();
    }

    private static String createString(SrLogCategories aCategory, Object ... aMsg) {
        for (Object curObj : aMsg) {
            if (!(curObj instanceof Throwable)) continue;
            Throwable curThr = (Throwable)curObj;
            assert (false) : "The exception " + curObj + " has been logged in the wrong " + "logging method. You should always use the logging method that " + "specifically gets the exception as an argument, not through the " + "object list.";
            return SrLogger.createString(aCategory, curThr, aMsg);
        }
        return SrLogger.createString(aCategory, null, aMsg);
    }

    private static String createString(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
        StringBuilder conString = new StringBuilder();
        if (!aCategory.equals((Object)SrLogCategories.USER) && !aCategory.equals((Object)SrLogCategories.TRAP)) {
            conString.append(SrLogger.getCallerClassAndMethodName()).append(FIELD_DELIMITER);
            conString.append((Object)aCategory).append(FIELD_DELIMITER);
        }
        for (Object curMsg : aMsg) {
            if (curMsg == null) {
                conString.append("NULL");
                continue;
            }
            if (curMsg instanceof Object[]) {
                conString.append(Arrays.deepToString((Object[])curMsg));
                continue;
            }
            if (curMsg instanceof boolean[]) {
                conString.append(Arrays.toString((boolean[])curMsg));
                continue;
            }
            if (curMsg instanceof byte[]) {
                conString.append(Arrays.toString((byte[])curMsg));
                continue;
            }
            if (curMsg instanceof char[]) {
                conString.append(Arrays.toString((char[])curMsg));
                continue;
            }
            if (curMsg instanceof double[]) {
                conString.append(Arrays.toString((double[])curMsg));
                continue;
            }
            if (curMsg instanceof float[]) {
                conString.append(Arrays.toString((float[])curMsg));
                continue;
            }
            if (curMsg instanceof int[]) {
                conString.append(Arrays.toString((int[])curMsg));
                continue;
            }
            if (curMsg instanceof long[]) {
                conString.append(Arrays.toString((long[])curMsg));
                continue;
            }
            if (curMsg instanceof short[]) {
                conString.append(Arrays.toString((short[])curMsg));
                continue;
            }
            conString.append(curMsg.toString());
        }
        if (aExp != null) {
            conString.append(LINE_SEPARATOR).append(aExp.toString()).append(" The associated exception is:").append(LINE_SEPARATOR);
            conString.append(SrLogger.getThrowableOutput(aExp));
        }
        return conString.toString();
    }

    private String createEnteringString(Object[] aParameters, Object ... aMsg) {
        StringBuilder conString = new StringBuilder();
        conString.append(SrLogger.getCallerClassAndMethodName()).append(FIELD_DELIMITER);
        conString.append("ENTERING|Parameters: (");
        for (Object curParam : aParameters) {
            if (curParam != null) {
                conString.append(curParam).append(", ");
                continue;
            }
            conString.append("NULL, ");
        }
        conString.delete(conString.length() - 2, conString.length());
        conString.append(") ");
        for (Object curMsg : aMsg) {
            if (curMsg == null) {
                conString.append("NULL");
                continue;
            }
            conString.append(curMsg.toString());
        }
        return conString.toString();
    }

    private String createEnteringString() {
        StringBuilder conString = new StringBuilder();
        conString.append(SrLogger.getCallerClassAndMethodName()).append(FIELD_DELIMITER);
        conString.append("ENTERING|Parameters: ()");
        return conString.toString();
    }

    private String createExitingString(Object[] aRetValue, String aMsg) {
        StringBuilder conString = new StringBuilder();
        conString.append(SrLogger.getCallerClassAndMethodName()).append(FIELD_DELIMITER);
        conString.append("EXITING|Return value: (");
        if (aRetValue != null) {
            for (Object curVal : aRetValue) {
                if (curVal != null) {
                    conString.append(curVal.toString()).append(", ");
                    continue;
                }
                conString.append("NULL, ");
            }
        }
        conString.delete(conString.length() - 2, conString.length());
        conString.append(") ").append(aMsg);
        return conString.toString();
    }

    private String createExitingString() {
        StringBuilder conString = new StringBuilder();
        conString.append(SrLogger.getCallerClassAndMethodName()).append(FIELD_DELIMITER);
        conString.append("EXITING|Return value: ()");
        return conString.toString();
    }

    public void trace(SrLogCategories aCategory, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.TRACE)) {
            return;
        }
        this.myLogger.trace((Object)SrLogger.createString(aCategory, aMsg));
        this.restoreLogLevel(oldLevel);
    }

    public void debug(SrLogCategories aCategory, DebugLogObject aDebugObj) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.DEBUG)) {
            return;
        }
        this.myLogger.debug((Object)SrLogger.createString(aCategory, aDebugObj));
        this.restoreLogLevel(oldLevel);
    }

    public void debug(SrLogCategories aCategory, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.DEBUG)) {
            return;
        }
        this.myLogger.debug((Object)SrLogger.createString(aCategory, aMsg));
        this.restoreLogLevel(oldLevel);
    }

    private void restoreLogLevel(Level aLevel) {
        if (aLevel != null) {
            this.setLevel(aLevel);
        }
    }

    public void info(SrLogCategories aCategory, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.INFO)) {
            return;
        }
        this.myLogger.info((Object)SrLogger.createString(aCategory, aMsg));
        this.restoreLogLevel(oldLevel);
    }

    public void warn(SrLogCategories aCategory, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.WARN)) {
            return;
        }
        this.myLogger.warn((Object)SrLogger.createString(aCategory, aMsg));
        this.restoreLogLevel(oldLevel);
    }

    public void error(SrLogCategories aCategory, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.ERROR)) {
            return;
        }
        this.myLogger.error((Object)SrLogger.createString(aCategory, aMsg));
        this.restoreLogLevel(oldLevel);
    }

    public void logAndAssert(SrLogCategories aCategory, Throwable aThr, Object ... aMsg) {
        this.logAndAssert(aCategory, false, aThr, aMsg);
    }

    public void logAndAssert(SrLogCategories aCategory, Throwable aThr) {
        this.logAndAssert(aCategory, false, aThr, new Object[0]);
    }

    public void logAndAssert(SrLogCategories aCategory, Object ... aMsg) {
        this.logAndAssert(aCategory, false, aMsg);
    }

    public void logAndAssert(SrLogCategories aCategory, boolean aIsSuccessAssert, Object ... aMsg) {
        this.logAndAssert(aCategory, aIsSuccessAssert, null, aMsg);
    }

    public void logAndAssert(SrLogCategories aCategory, boolean aIsSuccessAssert, Throwable aThr, Object ... aMsg) {
        if (aIsSuccessAssert) {
            return;
        }
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        StringBuilder strBuf = new StringBuilder();
        if (aMsg != null) {
            for (Object curObj : aMsg) {
                if (curObj == null) continue;
                strBuf.append(curObj.toString());
            }
        }
        if (this.myLogger.isEnabledFor((Priority)Level.ERROR)) {
            this.myLogger.error((Object)SrLogger.createString(aCategory, aThr, aMsg));
        }
        this.restoreLogLevel(oldLevel);
        assert (aIsSuccessAssert) : strBuf.toString();
    }

    public <T extends Throwable> void logAndThrow(SrLogCategories aCategory, T aExp, Object ... aMsg) throws T {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (this.myLogger.isEnabledFor((Priority)Level.ERROR)) {
            String logEntry = SrLogger.createString(aCategory, aMsg);
            this.myLogger.error((Object)logEntry);
            this.myExceptionLogger.error((Object)logEntry);
        }
        this.restoreLogLevel(oldLevel);
        throw aExp;
    }

    public void error(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.ERROR)) {
            return;
        }
        String logEntry = SrLogger.createString(aCategory, aExp, aMsg);
        this.myLogger.error((Object)logEntry);
        this.myExceptionLogger.error((Object)logEntry);
        this.restoreLogLevel(oldLevel);
    }

    public void fatal(SrLogCategories aCategory, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.FATAL)) {
            return;
        }
        this.myLogger.fatal((Object)SrLogger.createString(aCategory, aMsg));
        this.restoreLogLevel(oldLevel);
    }

    public void fatal(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
        Level oldLevel = this.myLogger.getLevel();
        if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
            this.setLevel(Level.ALL);
        }
        if (!this.myLogger.isEnabledFor((Priority)Level.FATAL)) {
            return;
        }
        String logEntry = SrLogger.createString(aCategory, aExp, aMsg);
        this.myLogger.fatal((Object)logEntry);
        this.myExceptionLogger.fatal((Object)logEntry);
        this.restoreLogLevel(oldLevel);
    }

    public void traceEntering(String aMsg, Object ... aParameters) {
        if (!this.myLogger.isEnabledFor((Priority)Level.TRACE)) {
            return;
        }
        if (aMsg != null) {
            this.myLogger.trace((Object)this.createEnteringString(aParameters, aMsg));
        } else {
            this.myLogger.trace((Object)this.createEnteringString(aParameters, ""));
        }
    }

    public void traceEntering() {
        if (!this.myLogger.isEnabledFor((Priority)Level.TRACE)) {
            return;
        }
        this.myLogger.trace((Object)this.createEnteringString());
    }

    public void traceExiting(String aMsg, Object ... aRetValue) {
        if (!this.myLogger.isEnabledFor((Priority)Level.TRACE)) {
            return;
        }
        if (aMsg != null) {
            this.myLogger.trace((Object)this.createExitingString(aRetValue, aMsg));
        } else {
            this.myLogger.trace((Object)this.createExitingString(aRetValue, ""));
        }
    }

    public void traceExiting() {
        if (!this.myLogger.isEnabledFor((Priority)Level.TRACE)) {
            return;
        }
        this.myLogger.trace((Object)this.createExitingString());
    }

    public String getName() {
        return this.myLogger.getName();
    }

    private static List<Level> getLoggingLevels() {
        ArrayList<Level> retList = new ArrayList<Level>();
        retList.addAll(SrLogger.getLoggingLevels(Level.class));
        retList.addAll(SrLogger.getLoggingLevels(Priority.class));
        Collections.sort(retList, new LogLevelComperator());
        return retList;
    }

    private static List<Level> getLoggingLevels(Class aLevelsClass) {
        Field[] levelFields;
        ArrayList<Level> retList = new ArrayList<Level>();
        if (aLevelsClass == null) {
            assert (false) : "The given class should not be null.";
            return retList;
        }
        for (Field curField : levelFields = aLevelsClass.getDeclaredFields()) {
            String fieldName = curField.toString();
            if (!fieldName.endsWith("_INT")) continue;
            String[] fieldParts = fieldName.split("\\.");
            String levelName = fieldParts[fieldParts.length - 1];
            if ((levelName = levelName.substring(0, levelName.length() - 4)).equals("ALL")) continue;
            retList.add(Level.toLevel((String)levelName));
        }
        Collections.sort(retList, new LogLevelComperator());
        return retList;
    }

    public static Collection<String> getLevelStrings(Iterable<Level> aLevels) {
        if (aLevels == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        ArrayList<String> levelStrs = new ArrayList<String>();
        for (Level curLevel : aLevels) {
            if (Level.DEBUG.equals((Object)curLevel)) {
                levelStrs.add(DEBUG_STRING);
                continue;
            }
            levelStrs.add(curLevel.toString());
        }
        return levelStrs;
    }

    public static String sanradStringRepToLog4jStringRep(String aStringRep) {
        if (aStringRep == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        if (DEBUG_STRING.equals(aStringRep)) {
            return Level.DEBUG.toString();
        }
        if (Level.toLevel((String)aStringRep, null) == null) {
            throw new IllegalArgumentException("The string representation " + aStringRep + " does not correspond with any SANRAD level.");
        }
        return aStringRep;
    }

    public static String log4jStringRepToSanradStringRep(String aStringRep) {
        if (aStringRep == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        if (Level.DEBUG.toString().equals(aStringRep)) {
            return DEBUG_STRING;
        }
        if (INVALID_STRING.equals(aStringRep)) {
            return INVALID_STRING;
        }
        if (Level.toLevel((String)aStringRep, null) == null) {
            throw new IllegalArgumentException("The string representation " + aStringRep + " does not correspond with any log4j level.");
        }
        return aStringRep;
    }

    private static class SrDummyLog
    extends SrLogger {
        private static SrDummyLog theInstance = new SrDummyLog();
        private String myName = "Dummy logger";

        public static synchronized SrDummyLog getInstance() {
            System.out.println("A dummy log was returned!!!");
            System.out.println("Please verify that logging properties are valid, and that the connection to the server could be established.");
            System.out.println("All log entries would be outputed to the console.");
            return theInstance;
        }

        protected SrDummyLog() {
            super(null);
        }

        @Override
        public void setLevel(Level aLevel) {
        }

        @Override
        public void trace(SrLogCategories aCategory, Object ... aMsg) {
            this.printIfSystem(aCategory, aMsg);
        }

        @Override
        public void traceEntering(String aMsg, Object ... aParameters) {
        }

        @Override
        public void traceEntering() {
        }

        @Override
        public void traceExiting(String aMsg, Object ... aRetValue) {
        }

        @Override
        public void traceExiting() {
        }

        @Override
        public Level getLevel() {
            return Level.OFF;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public boolean isEnabledFor(Level aLevel) {
            return false;
        }

        @Override
        public void debug(SrLogCategories aCategory, DebugLogObject aDebugObj) {
            this.printIfSystem(aCategory, aDebugObj);
        }

        @Override
        public void debug(SrLogCategories aCategory, Object ... aMsg) {
            this.printIfSystem(aCategory, aMsg);
        }

        @Override
        public void logAndAssert(SrLogCategories aCategory, Throwable aThr, Object ... aMsg) {
            this.logAndAssert(aCategory, false, aThr, aMsg);
        }

        @Override
        public void logAndAssert(SrLogCategories aCategory, Throwable aThr) {
            this.logAndAssert(aCategory, false, aThr, new Object[0]);
        }

        @Override
        public void logAndAssert(SrLogCategories aCategory, Object ... aMsg) {
            this.logAndAssert(aCategory, false, aMsg);
        }

        @Override
        public void logAndAssert(SrLogCategories aCategory, boolean aIsSuccessAssert, Object ... aMsg) {
            this.logAndAssert(aCategory, aIsSuccessAssert, null, aMsg);
        }

        @Override
        public void logAndAssert(SrLogCategories aCategory, boolean aIsSuccessAssert, Throwable aThr, Object ... aMsg) {
            if (aIsSuccessAssert) {
                return;
            }
            StringBuilder strBuf = new StringBuilder();
            if (aMsg != null) {
                for (Object curObj : aMsg) {
                    if (curObj == null) continue;
                    strBuf.append(curObj.toString());
                }
            }
            this.printToConsole(aCategory, strBuf);
            assert (aIsSuccessAssert) : strBuf.toString();
        }

        @Override
        public <T extends Throwable> void logAndThrow(SrLogCategories aCategory, T aExp, Object ... aMsg) throws T {
            this.printToConsole(aCategory, aExp, aMsg);
            throw aExp;
        }

        @Override
        public void info(SrLogCategories aCategory, Object ... aMsg) {
            this.printIfSystem(aCategory, aMsg);
        }

        @Override
        public void warn(SrLogCategories aCategory, Object ... aMsg) {
            this.printIfSystem(aCategory, aMsg);
        }

        @Override
        public void error(SrLogCategories aCategory, Object ... aMsg) {
            this.printToConsole(aCategory, aMsg);
        }

        @Override
        public void error(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
            this.printToConsole(aCategory, aExp, aMsg);
        }

        @Override
        public void fatal(SrLogCategories aCategory, Object ... aMsg) {
            this.printToConsole(aCategory, aMsg);
        }

        @Override
        public void fatal(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
            this.printToConsole(aCategory, aExp, aMsg);
        }

        private void printIfSystem(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
            if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
                this.printToConsole(aCategory, aExp, aMsg);
            }
        }

        private void printIfSystem(SrLogCategories aCategory, Object ... aMsg) {
            if (aCategory.equals((Object)SrLogCategories.SYSTEM)) {
                this.printToConsole(aCategory, aMsg);
            }
        }

        private void printToConsole(SrLogCategories aCategory, Throwable aExp, Object ... aMsg) {
            System.out.println(SrLogger.createString(aCategory, aExp, aMsg));
        }

        private void printToConsole(SrLogCategories aCategory, Object ... aMsg) {
            System.out.println(SrLogger.createString(aCategory, aMsg));
        }
    }

    private static class LogLevelComperator<T extends Level>
    implements Comparator {
        private LogLevelComperator() {
        }

        public int compare(Object aLevel1, Object aLevel2) {
            Level first = (Level)aLevel1;
            Level second = (Level)aLevel2;
            if (first.isGreaterOrEqual((Priority)second)) {
                return 1;
            }
            if (second.isGreaterOrEqual((Priority)first)) {
                return -1;
            }
            return 0;
        }
    }
}

