/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.LogManager;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;

public class LogManagerImpl
extends RemoteObjectImpl
implements LogManager {
    private static LogManager theInstance;
    private static String CLIENT_CONFIG_FILE_NAME;
    private static String CLI_CONFIG_FILE_NAME;
    private static String SERVER_CONFIG_FILE_NAME;

    protected LogManagerImpl() throws RemoteException {
    }

    @Override
    public Properties getClientLogProps() throws RemoteException {
        return this.getPropertiesByFile(CLIENT_CONFIG_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogProps(Properties aProps, String aFileName) throws RemoteException {
        if (aProps == null) {
            assert (false) : "The given properties should not be null.";
            return;
        }
        FileOutputStream outFile = null;
        try {
            outFile = new FileOutputStream(aFileName, false);
            aProps.store(outFile, "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LogicMgrAOImpl.getInstance().logConfigChange((ElementEvent)new ElementEventImpl((Object)this, aProps));
    }

    @Override
    public void setClientLogProperties(Properties aProps) throws RemoteException {
        if (aProps == null) {
            assert (false) : "The given properties should not be null.";
            return;
        }
        this.setLogProps(aProps, CLIENT_CONFIG_FILE_NAME);
    }

    @Override
    public void setServerLogProperties(Properties aProps) throws RemoteException {
        if (aProps == null) {
            assert (false) : "The given properties should not be null.";
            return;
        }
        this.setLogProps(aProps, SERVER_CONFIG_FILE_NAME);
        SrLogger.reInit(aProps);
    }

    @Override
    public Properties getServerLogProps() throws RemoteException {
        return this.getPropertiesByFile(SERVER_CONFIG_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPropertiesByFile(String aFileName) {
        if (aFileName == null || aFileName.equals("")) {
            assert (false) : "Invalid configuration file given as a parameter.";
            System.err.println("Could not find the log properties file.");
            return new Properties();
        }
        Properties retProp = new Properties();
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(aFileName);
            retProp.load(inFile);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find the log properties file.");
        }
        catch (IOException e) {
            System.err.println("Could not find the log properties file.");
        }
        catch (NullPointerException e) {
            System.err.println("Could not find the log properties file.");
        }
        finally {
            try {
                inFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retProp;
    }

    public static LogManager getInstance() throws RemoteException {
        return theInstance;
    }

    @Override
    public void setCliLogProperties(Properties aProps) throws RemoteException {
        if (aProps == null) {
            assert (false) : "The given properties should not be null.";
            return;
        }
        this.setLogProps(aProps, CLI_CONFIG_FILE_NAME);
    }

    @Override
    public Properties getCliLogProps() throws RemoteException {
        return this.getPropertiesByFile(CLI_CONFIG_FILE_NAME);
    }

    static {
        CLIENT_CONFIG_FILE_NAME = "config" + File.separator + "clientLog.properties";
        CLI_CONFIG_FILE_NAME = "config" + File.separator + "cliLog.properties";
        SERVER_CONFIG_FILE_NAME = "config" + File.separator + "log.properties";
        theLogger = SrLogger.getLogger();
        try {
            theInstance = new LogManagerImpl();
        }
        catch (RemoteException e) {
            System.err.println("Could not initialize the log manager.");
            theInstance = null;
        }
    }
}

