/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp.v1;

import monfox.toolkit.snmp.ber.BERBuffer;
import monfox.toolkit.snmp.ber.BERCoder;
import monfox.toolkit.snmp.ber.BERException;
import monfox.toolkit.snmp.engine.SnmpCoderException;
import monfox.toolkit.snmp.engine.SnmpMessage;
import monfox.toolkit.snmp.engine.SnmpMessageModule;
import monfox.toolkit.snmp.engine.SnmpMessageProfile;
import monfox.toolkit.snmp.engine.SnmpPDU;
import monfox.toolkit.snmp.engine.SnmpPDUCoder;
import monfox.toolkit.snmp.engine.SnmpSecurityParameters;
import monfox.toolkit.snmp.metadata.SnmpMetadata;
import monfox.toolkit.snmp.metadata.gen.Message;
import monfox.toolkit.snmp.v1.V1SnmpSecurityParameters;

public class V1SnmpMessageModule
implements SnmpMessageModule {
    private SnmpPDUCoder a = null;
    private SnmpMetadata b = null;
    private static final String c = "$Id: V1SnmpMessageModule.java,v 1.6 2002/02/05 23:18:05 sking Exp $";

    public V1SnmpMessageModule() {
        this(null);
    }

    public V1SnmpMessageModule(SnmpMetadata snmpMetadata) {
        this.b = snmpMetadata;
        this.a = new SnmpPDUCoder(snmpMetadata);
    }

    public SnmpMessage decodeMessage(int n2, BERBuffer bERBuffer) throws SnmpCoderException {
        boolean bl2 = V1SnmpSecurityParameters.c;
        try {
            byte[] byArray = BERCoder.decodeString(bERBuffer, 4);
            int n3 = bERBuffer.getIndex();
            SnmpPDU snmpPDU = this.a.decodePDU(bERBuffer);
            snmpPDU.setCommunity(byArray);
            snmpPDU.setVersion(n2);
            SnmpMessage snmpMessage = new SnmpMessage();
            snmpMessage.setData(snmpPDU);
            snmpMessage.setVersion(n2);
            snmpMessage.setMsgID(snmpPDU.getRequestId());
            V1SnmpSecurityParameters v1SnmpSecurityParameters = new V1SnmpSecurityParameters(byArray);
            snmpMessage.setSecurityParameters(v1SnmpSecurityParameters);
            if (bl2) {
                Message.d = !Message.d;
            }
            return snmpMessage;
        }
        catch (BERException bERException) {
            throw new SnmpCoderException(bERException.getMessage());
        }
    }

    public BERBuffer encodeMessage(SnmpMessage snmpMessage, int n2) throws SnmpCoderException {
        boolean bl2 = V1SnmpSecurityParameters.c;
        try {
            BERBuffer bERBuffer;
            block8: {
                SnmpSecurityParameters snmpSecurityParameters;
                block7: {
                    SnmpMessageProfile snmpMessageProfile = snmpMessage.getMessageProfile();
                    snmpSecurityParameters = snmpMessage.getSecurityParameters();
                    bERBuffer = new BERBuffer();
                    this.a.encodePDU(bERBuffer, snmpMessage.getData(), n2);
                    if (snmpMessageProfile == null) break block7;
                    BERCoder.encodeString(bERBuffer, snmpMessageProfile.getSecurityNameBytes(), 4);
                    if (!bl2) break block8;
                }
                if (snmpSecurityParameters != null) {
                    BERCoder.encodeString(bERBuffer, snmpSecurityParameters.getSecurityName(), 4);
                }
            }
            BERCoder.encodeInteger(bERBuffer, snmpMessage.getVersion(), 2);
            BERCoder.encodeLength(bERBuffer);
            BERCoder.encodeTag(bERBuffer, 48);
            if (Message.d) {
                V1SnmpSecurityParameters.c = !bl2;
            }
            return bERBuffer;
        }
        catch (BERException bERException) {
            throw new SnmpCoderException(bERException.getMessage());
        }
    }
}

