/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp.metadata;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import monfox.toolkit.snmp.Snmp;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.metadata.RangeItem;
import monfox.toolkit.snmp.metadata.SnmpDisplayHint;
import monfox.toolkit.snmp.metadata.SnmpModule;
import monfox.toolkit.snmp.metadata.SnmpOidInfo;
import monfox.toolkit.snmp.util.TextBuffer;

public class SnmpTypeInfo
implements Serializable {
    static final long serialVersionUID = -766138160407080196L;
    private int _smiType = -1;
    private String _description = null;
    private SnmpModule _module = null;
    private RangeItem[] _rangeSpec = null;
    private int _type = -1;
    private String _definedType = null;
    private String _displayHint = null;
    private String _status = SnmpTypeInfo.a("V[GX\n[Z");
    private String _name = null;
    private SnmpTypeInfo _baseType = null;
    private int _fixedSize = -1;
    private Hashtable _nameToNumberMap = null;
    private Hashtable _numberToNameMap = null;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private transient SnmpDisplayHint a = null;

    public SnmpTypeInfo(SnmpTypeInfo snmpTypeInfo) {
        this._name = snmpTypeInfo._name;
        this._definedType = snmpTypeInfo._definedType;
        this._type = snmpTypeInfo._type;
        this._displayHint = snmpTypeInfo._displayHint;
        this._rangeSpec = snmpTypeInfo._rangeSpec;
        this._nameToNumberMap = snmpTypeInfo._nameToNumberMap;
        this._numberToNameMap = snmpTypeInfo._numberToNameMap;
    }

    public SnmpTypeInfo(String string, String string2, String string3, String string4) throws SnmpValueException {
        this._name = string;
        this._definedType = string2;
        this._type = SnmpValue.stringToType(string3);
        if (this._type == -1) {
            throw new SnmpValueException(SnmpTypeInfo.a("@@^D\u0000B@\u0015^\u0016EK\u000f\n") + string3);
        }
        this._displayHint = string4;
    }

    public String getName() {
        return this._name;
    }

    public String getDefinedType() {
        return this._definedType;
    }

    public int getType() {
        return this._type;
    }

    public String getTypeString() {
        return SnmpValue.typeToString(this._type);
    }

    public String getTypeShortString() {
        return SnmpValue.typeToShortString(this._type);
    }

    public String getDisplayHint() {
        return this._displayHint;
    }

    public SnmpDisplayHint getSnmpDisplayHint() {
        block4: {
            block5: {
                if (this.a != null) break block4;
                if (this._displayHint == null) break block5;
                this.a = new SnmpDisplayHint(this._displayHint);
                if (!SnmpOidInfo.a) break block4;
            }
            if (this._baseType != null) {
                this.a = this._baseType.getSnmpDisplayHint();
            }
        }
        return this.a;
    }

    public void setDisplayHint(String string) {
        this._displayHint = string;
        this.a = null;
    }

    public boolean isFixedSize() {
        return this._rangeSpec != null && this._rangeSpec.length == 1 && this._rangeSpec[0].isSingle();
    }

    public int getFixedSize() {
        if (this._rangeSpec != null && this._rangeSpec.length == 1) {
            return this._rangeSpec[0].getSingleValue().intValue();
        }
        return -1;
    }

    public SnmpTypeInfo(Hashtable hashtable) {
        this.setNameToNumberMap(hashtable);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void setNameToNumberMap(Hashtable hashtable) {
        if (hashtable != null) {
            this._nameToNumberMap = hashtable;
            if (this._nameToNumberMap != null) {
                this._numberToNameMap = new Hashtable();
                Enumeration enumeration = this._nameToNumberMap.keys();
                boolean bl2 = true;
                do {
                    if (bl2 && !(bl2 = false) && !SnmpOidInfo.a) continue;
                    String string = (String)enumeration.nextElement();
                    Long l2 = (Long)this._nameToNumberMap.get(string);
                    this._numberToNameMap.put(l2, string);
                } while (enumeration.hasMoreElements());
            }
        }
    }

    public Hashtable getNameToNumberMap() {
        return this._nameToNumberMap;
    }

    public Hashtable getNumberToNameMap() {
        return this._numberToNameMap;
    }

    public String intToNamedNumber(long l2) {
        if (this._numberToNameMap != null) {
            String string = (String)this._numberToNameMap.get(new Long(l2));
            return string;
        }
        return null;
    }

    public int namedNumberToInt(String string) throws NumberFormatException {
        long l2 = this.namedNumberToLong(string);
        return (int)l2;
    }

    public long namedNumberToLong(String string) throws NumberFormatException {
        Long l2;
        if (this._nameToNumberMap != null && (l2 = (Long)this._nameToNumberMap.get(string)) != null) {
            return l2;
        }
        return Integer.parseInt(string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public byte[] namedBitsStringToBytes(String string) throws SnmpValueException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SnmpTypeInfo.a("NS\u0015\u0006A\u0013"), false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !SnmpOidInfo.a) continue;
            stringArray[n2++] = stringTokenizer.nextToken();
        } while (stringTokenizer.hasMoreTokens());
        return this.namedBitsToBytes(stringArray);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] namedBitsToBytes(String[] stringArray) throws SnmpValueException {
        boolean bl2 = SnmpOidInfo.a;
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl2) continue;
            String string = stringArray[n3];
            try {
                int n4 = (int)this.namedNumberToLong(string);
                if (n4 > n2) {
                    n2 = n4;
                }
                nArray[n3] = n4;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpValueException(SnmpTypeInfo.a("`@^D\u0000B@\u0015H\u0006A\u000e[K\u0002P\u000e\u0012") + string + "'");
            }
            ++n3;
        } while (n3 < stringArray.length);
        int n5 = n2 / 8 + 1;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        boolean bl4 = true;
        do {
            int n7;
            if (bl4 && !(bl4 = false) && !bl2) continue;
            int n8 = nArray[n6];
            int n9 = n7 = n8 / 8;
            byArray[n9] = (byte)(byArray[n9] | (byte)(128 >> n8 % 8));
            ++n6;
        } while (n6 < nArray.length);
        return byArray;
    }

    public String bytesToNamedBitsString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        this.bytesToNamedBitsString(stringBuffer, byArray);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void bytesToNamedBitsString(StringBuffer var1_1, byte[] var2_2) {
        block6: {
            block5: {
                var5_3 = SnmpOidInfo.a;
                var3_4 = this.bytesToNamedBits(var2_2, true);
                if (var3_4 == null) break block5;
                var1_1.append(SnmpTypeInfo.a("N\u000e"));
                var4_5 = 0;
                if (!var5_3) ** GOTO lbl16
                block0: while (true) {
                    if (var4_5 > 0) {
                        var1_1.append(SnmpTypeInfo.a("\u0019\u000e"));
                    }
                    var1_1.append(var3_4[var4_5]);
                    do {
                        ++var4_5;
lbl16:
                        // 2 sources

                        if (var4_5 < var3_4.length) continue block0;
                        var1_1.append(SnmpTypeInfo.a("\u0015S"));
                    } while (var5_3 && var5_3);
                    break;
                }
                break block6;
            }
            var1_1.append("'");
            var4_6 = 0;
            if (!var5_3) ** GOTO lbl32
            block2: while (true) {
                var1_1.append(SnmpTypeInfo.hexDigits[var2_2[var4_6] >> 4 & 15]);
                v0 = var1_1.append(SnmpTypeInfo.hexDigits[var2_2[var4_6] & 15]);
                do {
                    ++var4_6;
lbl32:
                    // 2 sources

                    if (var4_6 < var2_2.length) continue block2;
                    v0 = var1_1.append(SnmpTypeInfo.a("\u0012f"));
                } while (var5_3);
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String[] bytesToNamedBits(byte[] var1_1, boolean var2_2) {
        var10_3 = SnmpOidInfo.a;
        if (this._nameToNumberMap == null || this._nameToNumberMap.size() == 0) {
            return null;
        }
        var3_4 = new Vector<String>();
        var4_5 = true;
        var5_6 = 0;
        if (!var10_3) ** GOTO lbl33
        block0: while (true) {
            v0 = var1_1[var5_6];
            do {
                var6_7 = v0;
                var7_9 = 0;
                if (!var10_3) ** GOTO lbl30
                block2: while (true) {
                    block11: {
                        block12: {
                            if ((var6_7 & (byte)(128 >> var7_9)) == 0) break block11;
                            var8_10 = 8 * var5_6 + var7_9;
                            var9_11 = this.intToNamedNumber(var8_10);
                            if (var9_11 != null) break block12;
                            if (var2_2) {
                                return null;
                            }
                            var3_4.add(String.valueOf(var8_10));
                            if (!var10_3) break block11;
                        }
                        var3_4.add(var9_11);
                    }
                    do {
                        ++var7_9;
lbl30:
                        // 2 sources

                        if (var7_9 < 8) continue block2;
                    } while (var10_3);
                    break;
                }
                ++var5_6;
lbl33:
                // 2 sources

                if (var5_6 < var1_1.length) continue block0;
                var6_8 = new String[var3_4.size()];
                v0 = 0;
            } while (var10_3);
            break;
        }
        var7_9 = v0;
        if (!var10_3) ** GOTO lbl44
        block4: while (true) {
            v1 = var6_8;
            do {
                v1[var7_9] = (String)var3_4.get(var7_9);
                ++var7_9;
lbl44:
                // 2 sources

                if (var7_9 < var3_4.size()) continue block4;
                v1 = var6_8;
            } while (var10_3);
            break;
        }
        return v1;
    }

    public boolean hasRangeSpec() {
        return this._rangeSpec != null;
    }

    public RangeItem[] getRangeSpec() {
        return this._rangeSpec;
    }

    public void setRangeSpec(RangeItem[] rangeItemArray) {
        this._rangeSpec = rangeItemArray;
    }

    public SnmpModule getModule() {
        return this._module;
    }

    void a(SnmpModule snmpModule) {
        this._module = snmpModule;
    }

    public String toString() {
        TextBuffer textBuffer = new TextBuffer();
        this.toString(textBuffer);
        return textBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void toString(TextBuffer var1_1) {
        block28: {
            block24: {
                block25: {
                    block27: {
                        block26: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                var5_2 = SnmpOidInfo.a;
                                                if (this._module == null) break block19;
                                                var1_1.append(this._name).append(SnmpTypeInfo.a("\u0015zlz*\u0015\u0013\u0015"));
                                                if (!var5_2) break block20;
                                            }
                                            var1_1.append(SnmpTypeInfo.a("AWEO&[HZ\nR\u0015"));
                                        }
                                        if (this._definedType == null) break block21;
                                        var1_1.append(this._definedType);
                                        if (!var5_2) break block22;
                                    }
                                    var1_1.append(this.getSmiTypeString());
                                }
                                if (this._nameToNumberMap == null) break block23;
                                var1_1.append(SnmpTypeInfo.a("N\u000e"));
                                var2_3 = this._nameToNumberMap.keys();
                                if (!var5_2) ** GOTO lbl32
                                block0: while (true) {
                                    v0 /* !! */  = var2_3.nextElement();
                                    do {
                                        var3_5 = (String)v0 /* !! */ ;
                                        var4_6 = (Long)this._nameToNumberMap.get(var3_5);
                                        v1 = var1_1.append(var3_5 + "(" + var4_6 + ")");
                                        while (var2_3.hasMoreElements()) {
                                            v1 = var1_1.append(SnmpTypeInfo.a("\u0019\u000e"));
                                            if (var5_2) continue;
                                        }
lbl32:
                                        // 3 sources

                                        if (var2_3.hasMoreElements()) continue block0;
                                        v0 /* !! */  = var1_1.append(SnmpTypeInfo.a("\u0015S"));
                                    } while (var5_2);
                                    break;
                                }
                            }
                            if (this._displayHint == null && this._rangeSpec == null) break block24;
                            var1_1.pushIndent();
                            if (this._displayHint != null) {
                                var1_1.append(SnmpTypeInfo.a("QGFZ\u0003TW}C\u0001A\u000e\b\n")).append(this._displayHint).append("\n");
                            }
                            if (this._rangeSpec == null) break block25;
                            if (this._type != 4) break block26;
                            var1_1.append(SnmpTypeInfo.a("FGOO"));
                            if (!var5_2) break block27;
                        }
                        var1_1.append(SnmpTypeInfo.a("GO[M\n"));
                    }
                    var1_1.append("(");
                    var2_4 = 0;
                    if (!var5_2) ** GOTO lbl61
                    block3: while (true) {
                        this._rangeSpec[var2_4].toString(var1_1);
                        if (var2_4 + 1 < this._rangeSpec.length) {
                            v2 = var1_1.append("|");
                        }
                        do {
                            ++var2_4;
lbl61:
                            // 2 sources

                            if (var2_4 < this._rangeSpec.length) continue block3;
                            v2 = var1_1.append(SnmpTypeInfo.a("\u001c$"));
                        } while (var5_2);
                        break;
                    }
                }
                var1_1.popIndent();
                if (!var5_2) break block28;
            }
            var1_1.append("\n");
        }
    }

    public void setBaseType(SnmpTypeInfo snmpTypeInfo) {
        this._baseType = snmpTypeInfo;
    }

    public SnmpTypeInfo getBaseType() {
        return this._baseType;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setStatus(String string) {
        this._status = string;
    }

    public String getStatus() {
        return this._status;
    }

    public int getSmiType() {
        return this._smiType;
    }

    public void setSmiType(int n2) {
        this._smiType = n2;
    }

    public void setSmiType(String string) {
        this._smiType = Snmp.stringToSmiType(string);
    }

    public String getSmiTypeString() {
        return Snmp.smiTypeToString(this._smiType);
    }

    public String getSmiTypeShortString() {
        return Snmp.smiTypeToShortString(this._smiType);
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 53;
                    break;
                }
                case 1: {
                    n4 = 46;
                    break;
                }
                case 2: {
                    n4 = 53;
                    break;
                }
                case 3: {
                    n4 = 42;
                    break;
                }
                default: {
                    n4 = 111;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }
}

