/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp.metadata;

import monfox.toolkit.snmp.Snmp;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.metadata.SnmpMibInfo;
import monfox.toolkit.snmp.metadata.SnmpOidInfo;
import monfox.toolkit.snmp.metadata.SnmpTableInfo;
import monfox.toolkit.snmp.metadata.SnmpTypeInfo;
import monfox.toolkit.snmp.util.TextBuffer;

public class SnmpObjectInfo
extends SnmpMibInfo {
    static final long serialVersionUID = -5000633912054453468L;
    private int _smiType = -1;
    private int _type = -1;
    private boolean _implied = false;
    private int _access = -1;
    private boolean _isColumnar = false;
    private SnmpTypeInfo _typeInfo = null;
    private SnmpTableInfo _tableInfo = null;
    private String _defVal = null;
    private static final String _ident = "$Id: SnmpObjectInfo.java,v 1.22 2003/09/23 21:06:55 sking Exp $";

    public SnmpObjectInfo(String string, String string2) throws SnmpValueException {
        this._type = SnmpValue.stringToType(string);
        if (this._type == -1) {
            throw new SnmpValueException(SnmpObjectInfo.a("+\u001e]1L)\u001e\u0016+Z.\u0015\f\u007f") + string);
        }
        this._access = SnmpObjectInfo.stringToAccess(string2);
        if (this._access == -1) {
            throw new SnmpValueException(SnmpObjectInfo.a("+\u001e]1L)\u001e\u0016>@=\u0015E,\u0019~W") + string2 + SnmpObjectInfo.a("yP\u001e)B2\u0019R\u007fU?\u001cC:PdPD0\u000f)\u001f\u001a-Tr\u0002UsM?\\X6\u000f0\u001f\u001f"));
        }
    }

    public SnmpObjectInfo(String string) throws SnmpValueException {
        this._type = SnmpValue.stringToType(string);
        if (this._type == -1) {
            throw new SnmpValueException(SnmpObjectInfo.a("+\u001e]1L)\u001e\u0016+Z.\u0015\f\u007f") + string);
        }
        this._access = 0;
    }

    public SnmpObjectInfo(int n2) {
        this._type = n2;
        this._access = 0;
    }

    public SnmpObjectInfo(int n2, int n3) {
        this._type = n2;
        this._access = n3;
    }

    public int getType() {
        return this._type;
    }

    public SnmpTypeInfo getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(SnmpTypeInfo snmpTypeInfo) {
        this._typeInfo = snmpTypeInfo;
    }

    public boolean isImplied() {
        return this._implied;
    }

    public void setImplied(boolean bl2) {
        this._implied = bl2;
    }

    public String getTypeString() {
        return SnmpValue.typeToString(this._type);
    }

    public String getTypeShortString() {
        return SnmpValue.typeToShortString(this._type);
    }

    public int getAccess() {
        return this._access;
    }

    public String getAccessString() {
        return SnmpObjectInfo.accessToString(this._access);
    }

    public boolean isRead() {
        return (this._access & 1) != 0;
    }

    public boolean isWrite() {
        return (this._access & 2) != 0;
    }

    public boolean isCreate() {
        return (this._access & 5) != 0 || (this._access & 3) != 0;
    }

    public boolean isScalar() {
        return !this._isColumnar;
    }

    public boolean isColumnar() {
        return this._isColumnar;
    }

    public void setColumnar(boolean bl2) {
        this._isColumnar = bl2;
    }

    public SnmpTableInfo getTableInfo() {
        return this._tableInfo;
    }

    public void setTableInfo(SnmpTableInfo snmpTableInfo) {
        this._tableInfo = snmpTableInfo;
    }

    public int getSmiType() {
        return this._smiType;
    }

    public void setSmiType(int n2) {
        this._smiType = n2;
    }

    public void setSmiType(String string) {
        this._smiType = Snmp.stringToSmiType(string);
    }

    public String getSmiTypeString() {
        return Snmp.smiTypeToString(this._smiType);
    }

    public String getSmiTypeShortString() {
        return Snmp.smiTypeToShortString(this._smiType);
    }

    public void setDefVal(String string) {
        this._defVal = string;
    }

    public String getDefVal() {
        return this._defVal;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(SnmpObjectInfo.a("1\u0012\\:@*MM1B3\u0015\u000b"));
        stringBuffer.append(this.getName());
        stringBuffer.append(SnmpObjectInfo.a("r\u0004O/Fc"));
        stringBuffer.append(this.getTypeShortString());
        stringBuffer.append(SnmpObjectInfo.a("r\u0011U<F-\u0003\u000b"));
        stringBuffer.append(this.getAccessString());
        stringBuffer.append(SnmpObjectInfo.a("r\u0013Y3V3\u001eW-\u001e"));
        stringBuffer.append(this.isColumnar());
        if (this._tableInfo != null) {
            stringBuffer.append(SnmpObjectInfo.a("r\u0004W=O;M") + this._tableInfo.getName());
        }
        stringBuffer.append('}');
    }

    public void toString(TextBuffer textBuffer) {
        block2: {
            SnmpTypeInfo snmpTypeInfo;
            block3: {
                textBuffer.append(this.getName()).append(SnmpObjectInfo.a("~?t\u0015f\u001d$\u0016b\u0003"));
                textBuffer.append(this.getOid().toNumericString());
                textBuffer.pushIndent();
                textBuffer.append(SnmpObjectInfo.a("*\tF:\u0003~P\u0016b")).append(this.getTypeString()).append("\n");
                textBuffer.append(SnmpObjectInfo.a("?\u0013U:P-P\u0016b")).append(this.getAccessString()).append("\n");
                textBuffer.append(SnmpObjectInfo.a("=\u001fZ*N0\u0011Db")).append(this.isColumnar());
                snmpTypeInfo = this.getTypeInfo();
                if (snmpTypeInfo == null) break block2;
                if (snmpTypeInfo.getModule() != null) break block3;
                snmpTypeInfo.toString(textBuffer);
                if (!SnmpOidInfo.a) break block2;
            }
            textBuffer.append(SnmpObjectInfo.a("*\tF:Q;\u0016\u0016b"));
            textBuffer.append(snmpTypeInfo.getModule().getName());
            textBuffer.append(":").append(snmpTypeInfo.getName()).append("\n");
        }
        textBuffer.popIndent();
    }

    public static String accessToString(int n2) {
        switch (n2) {
            case 1: {
                return SnmpObjectInfo.a(",\u0015W;\u000e1\u001eZ&");
            }
            case 2: {
                return SnmpObjectInfo.a(")\u0002_+Fs\u001fX3Z");
            }
            case 3: {
                return SnmpObjectInfo.a(",\u0015W;\u000e)\u0002_+F");
            }
            case 5: {
                return SnmpObjectInfo.a(",\u0015W;\u000e=\u0002S>W;");
            }
            case 0: {
                return SnmpObjectInfo.a("0\u001fBrB=\u0013S,P7\u0012Z:");
            }
            case 16: {
                return SnmpObjectInfo.a("0\u001fBrJ3\u0000Z:N;\u001eB:G");
            }
            case 8: {
                return SnmpObjectInfo.a("?\u0013U:P-\u0019T3Fs\u0016Y-\u000e0\u001fB6E'");
            }
        }
        return "?";
    }

    public static String accessToShortString(int n2) {
        switch (n2) {
            case 1: {
                return SnmpObjectInfo.a(",\u001f");
            }
            case 2: {
                return SnmpObjectInfo.a(")\u001f");
            }
            case 3: {
                return SnmpObjectInfo.a(",\u0007");
            }
            case 5: {
                return SnmpObjectInfo.a(",\u0013");
            }
            case 0: {
                return SnmpObjectInfo.a("0\u0011");
            }
            case 16: {
                return SnmpObjectInfo.a("0\u0019");
            }
            case 8: {
                return SnmpObjectInfo.a("0\u001f");
            }
        }
        return "?";
    }

    public static int stringToAccess(String string) {
        String string2 = string.toLowerCase();
        if (SnmpObjectInfo.a(",\u001f").equals(string2)) {
            return 1;
        }
        if (SnmpObjectInfo.a(",\u0007").equals(string2)) {
            return 3;
        }
        if (SnmpObjectInfo.a(")\u001f").equals(string2)) {
            return 2;
        }
        if (SnmpObjectInfo.a(",\u0013").equals(string2)) {
            return 5;
        }
        if (SnmpObjectInfo.a("0\u0011").equals(string2)) {
            return 0;
        }
        if (SnmpObjectInfo.a("0\u001f").equals(string2)) {
            return 8;
        }
        if (SnmpObjectInfo.a("0\u0019").equals(string2)) {
            return 16;
        }
        return -1;
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 94;
                    break;
                }
                case 1: {
                    n4 = 112;
                    break;
                }
                case 2: {
                    n4 = 54;
                    break;
                }
                case 3: {
                    n4 = 95;
                    break;
                }
                default: {
                    n4 = 35;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }
}

