/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp.engine;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import monfox.log.Logger;
import monfox.toolkit.snmp.SnmpFramework;
import monfox.toolkit.snmp.engine.BufferedTransportProvider;
import monfox.toolkit.snmp.engine.SnmpBuffer;
import monfox.toolkit.snmp.engine.SnmpPDU;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.engine.TransportEntity;
import monfox.toolkit.snmp.engine.TransportProvider;
import monfox.toolkit.snmp.engine.UdpEntity;
import monfox.toolkit.snmp.util.ByteFormatter;

public class UdpTransportProvider
extends TransportProvider {
    private boolean a = true;
    private int b = -1;
    private InetAddress c = null;
    private static Logger d = null;
    private boolean e = true;
    private DatagramSocket f = null;
    private static final String g = "$Id: UdpTransportProvider.java,v 1.13 2004/09/24 19:42:43 sking Exp $";

    public UdpTransportProvider() {
        if (d == null) {
            d = Logger.getInstance(UdpTransportProvider.b("1(\u00192\u0012\u0005\"\u001a\u0016\u000f\u001689\u0014\u000f\u0012%\r\u0003\u0012"));
        }
        if ((SnmpFramework.getCompatFlags() & 1) != 0) {
            this.useDatagramOffset(false);
        }
    }

    public int getTransportType() {
        return 1;
    }

    public void initialize(InetAddress inetAddress, int n2) throws SnmpTransportException {
        boolean bl2 = SnmpPDU.i;
        if (this.f != null) {
            return;
        }
        try {
            block12: {
                block13: {
                    block11: {
                        if (n2 <= 0 || inetAddress == null) break block11;
                        this.f = new DatagramSocket(n2, inetAddress);
                        this.c = inetAddress;
                        this.b = n2;
                        if (!bl2) break block12;
                    }
                    if (n2 <= 0) break block13;
                    this.f = new DatagramSocket(n2);
                    this.c = this.f.getLocalAddress();
                    this.b = n2;
                    if (!bl2) break block12;
                }
                this.f = new DatagramSocket();
                this.c = this.f.getLocalAddress();
                this.b = this.f.getLocalPort();
            }
            if (this.c == null) {
                this.c = UdpTransportProvider.a();
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new SnmpTransportException(unknownHostException.getMessage());
        }
        catch (SocketException socketException) {
            throw new SnmpTransportException(UdpTransportProvider.b("'-\u0007\b\u000f\u0010l\u000b\u000f\u000e\u0000l\u001d\t@\u0014#\u001b\u0012@C") + n2 + UdpTransportProvider.b("CbIN") + socketException + ")");
        }
        if (d.isDebugEnabled()) {
            String string = null;
            if (this.c != null) {
                string = this.c.getHostAddress();
            }
            d.debug(UdpTransportProvider.b("'>\f\u0007\u0014\u0001l<\u0002\u00100>\b\b\u0013\u0014#\u001b\u00120\u0016#\u001f\u000f\u0004\u0001>A") + string + ":" + this.b + ")");
        }
    }

    private static InetAddress a() throws UnknownHostException {
        try {
            return InetAddress.getByName(UdpTransportProvider.b("\b#\n\u0007\f\f#\u001a\u0012"));
        }
        catch (Exception exception) {
            return InetAddress.getLocalHost();
        }
    }

    public InetAddress getAddress() {
        return this.c;
    }

    public int getLocalPort() {
        return this.b;
    }

    public DatagramSocket getSocket() {
        return this.f;
    }

    public boolean isActive() {
        return this.e;
    }

    public void shutdown() throws SnmpTransportException {
        d.debug(UdpTransportProvider.b("7\u0004<2$+\u001b'\\@") + this + UdpTransportProvider.b("^lA\u0015\u000f\u0007'\f\u0012ZD") + this.f + ")");
        this.e = false;
        this.f.close();
    }

    public Object send(Object object, TransportEntity transportEntity) throws SnmpTransportException {
        UdpEntity udpEntity = (UdpEntity)transportEntity;
        DatagramPacket datagramPacket = null;
        if (object instanceof SnmpBuffer) {
            SnmpBuffer snmpBuffer = (SnmpBuffer)object;
            if (snmpBuffer.offset == 0) {
                datagramPacket = new DatagramPacket(snmpBuffer.data, snmpBuffer.length, udpEntity.getAddress(), udpEntity.getPort());
            } else if (this.a) {
                datagramPacket = new DatagramPacket(snmpBuffer.data, snmpBuffer.offset, snmpBuffer.length, udpEntity.getAddress(), udpEntity.getPort());
            } else {
                byte[] byArray = new byte[snmpBuffer.length];
                System.arraycopy(snmpBuffer.data, snmpBuffer.offset, byArray, 0, snmpBuffer.length);
                datagramPacket = new DatagramPacket(byArray, byArray.length, udpEntity.getAddress(), udpEntity.getPort());
            }
        } else if (object instanceof DatagramPacket) {
            datagramPacket = (DatagramPacket)object;
        } else {
            throw new SnmpTransportException(UdpTransportProvider.b("1\"\u0002\b\u000f\u0013\"I\u0002\u0001\u0010-I\u0005\f\u0005?\u001a\\") + object.getClass().getName());
        }
        try {
            if (d.isDebugEnabled()) {
                d.debug(UdpTransportProvider.b("7\t'\")*\u000bI$90\t:\\@LF") + ByteFormatter.toString(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength()) + UdpTransportProvider.b("ne"));
            }
            this.f.send(datagramPacket);
        }
        catch (IOException iOException) {
            throw new SnmpTransportException(iOException.toString());
        }
        return datagramPacket;
    }

    public TransportEntity receive(SnmpBuffer snmpBuffer, boolean bl2) throws SnmpTransportException {
        try {
            Object object;
            if (!this.e) {
                throw new SnmpTransportException(UdpTransportProvider.b("\u0014>\u0006\u0010\t\u0000)\u001bF\u000e\u000b8I\u0007\u0003\u0010%\u001f\u0003"));
            }
            DatagramPacket datagramPacket = new DatagramPacket(snmpBuffer.data, snmpBuffer.data.length);
            this.f.receive(datagramPacket);
            if (d.isDebugEnabled()) {
                object = this.c != null ? this.c.getHostAddress() : UdpTransportProvider.b("TbYHPJ|");
                d.debug(UdpTransportProvider.b("6\t*#)2\t-F\"=\u0018,5ZD \u0000\u0015\u0014\u0001\"\f\u0014;") + (String)object + ":" + this.b + UdpTransportProvider.b("LF") + ByteFormatter.toString(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength()) + UdpTransportProvider.b("ne"));
            }
            snmpBuffer.length = datagramPacket.getLength();
            if (bl2) {
                object = datagramPacket.getAddress();
                int n2 = datagramPacket.getPort();
                UdpEntity udpEntity = new UdpEntity();
                udpEntity.initialize((InetAddress)object, n2);
                udpEntity.setProvider(this);
                return udpEntity;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new SnmpTransportException(iOException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer;
        block3: {
            block2: {
                stringBuffer = new StringBuffer();
                stringBuffer.append(UdpTransportProvider.b("L\u0019-6Z"));
                if (this.f == null) break block2;
                stringBuffer.append(this.f.getLocalAddress()).append(":");
                stringBuffer.append(this.f.getLocalPort());
                if (!SnmpPDU.i) break block3;
            }
            stringBuffer.append(":");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void useDatagramOffset(boolean bl2) {
        this.a = bl2;
    }

    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 100;
                    break;
                }
                case 1: {
                    n4 = 76;
                    break;
                }
                case 2: {
                    n4 = 105;
                    break;
                }
                case 3: {
                    n4 = 102;
                    break;
                }
                default: {
                    n4 = 96;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }

    public static class BufferedProvider
    extends BufferedTransportProvider {
        public BufferedProvider() {
            super(new UdpTransportProvider());
        }
    }
}

