/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp.engine;

import monfox.toolkit.snmp.ber.BERBuffer;
import monfox.toolkit.snmp.ber.BERCoder;
import monfox.toolkit.snmp.ber.BERException;
import monfox.toolkit.snmp.engine.SnmpBadVersionException;
import monfox.toolkit.snmp.engine.SnmpBuffer;
import monfox.toolkit.snmp.engine.SnmpCoderException;
import monfox.toolkit.snmp.engine.SnmpEngine;
import monfox.toolkit.snmp.engine.SnmpMessage;
import monfox.toolkit.snmp.engine.SnmpMessageModule;
import monfox.toolkit.snmp.metadata.SnmpMetadata;
import monfox.toolkit.snmp.v1.V1SnmpMessageModule;
import monfox.toolkit.snmp.v2.V2SnmpMessageModule;
import monfox.toolkit.snmp.v3.V3SnmpMessageModule;

public class SnmpMessageProcessor {
    private SnmpEngine a = null;
    private SnmpMessageModule b = null;
    private SnmpMessageModule c = null;
    private SnmpMessageModule d = null;
    private SnmpMetadata e = null;
    private static final String f = "$Id: SnmpMessageProcessor.java,v 1.4 2002/04/30 13:58:38 samin Exp $";

    public SnmpMessageProcessor(SnmpEngine snmpEngine) {
        this(snmpEngine, null);
    }

    public SnmpMessageProcessor(SnmpEngine snmpEngine, SnmpMetadata snmpMetadata) {
        this.a = snmpEngine;
        this.e = snmpMetadata;
        this.b = new V1SnmpMessageModule(snmpMetadata);
        this.c = new V2SnmpMessageModule(snmpMetadata);
        this.d = new V3SnmpMessageModule(snmpMetadata, this.a);
    }

    public SnmpMessageModule getMessageModule(int n2) {
        switch (n2) {
            case 0: {
                return this.b;
            }
            case 1: {
                return this.c;
            }
            case 3: {
                return this.d;
            }
        }
        return null;
    }

    public SnmpMessage decodeMessage(SnmpBuffer snmpBuffer) throws SnmpCoderException {
        try {
            BERBuffer bERBuffer = new BERBuffer(snmpBuffer.data, snmpBuffer.offset, snmpBuffer.length);
            BERCoder.expectTag(bERBuffer, 48);
            int n2 = BERCoder.getLength(bERBuffer);
            int n3 = bERBuffer.getIndex();
            int n4 = (int)BERCoder.decodeInteger(bERBuffer, 2);
            SnmpMessage snmpMessage = null;
            switch (n4) {
                case 0: {
                    snmpMessage = this.b.decodeMessage(n4, bERBuffer);
                    break;
                }
                case 1: {
                    snmpMessage = this.c.decodeMessage(n4, bERBuffer);
                    break;
                }
                case 3: {
                    snmpMessage = this.d.decodeMessage(n4, bERBuffer);
                    break;
                }
                default: {
                    throw new SnmpBadVersionException(n4);
                }
            }
            return snmpMessage;
        }
        catch (BERException bERException) {
            throw new SnmpCoderException(bERException.getMessage());
        }
    }

    public SnmpBuffer encodeMessage(SnmpMessage snmpMessage, int n2) throws SnmpCoderException {
        BERBuffer bERBuffer = null;
        switch (snmpMessage.getVersion()) {
            case 0: {
                bERBuffer = this.b.encodeMessage(snmpMessage, n2);
                break;
            }
            case 1: {
                bERBuffer = this.c.encodeMessage(snmpMessage, n2);
                break;
            }
            case 3: {
                bERBuffer = this.d.encodeMessage(snmpMessage, n2);
                break;
            }
            default: {
                throw new SnmpBadVersionException(snmpMessage.getVersion());
            }
        }
        int n3 = bERBuffer.getOffset();
        int n4 = bERBuffer.getLength();
        byte[] byArray = bERBuffer.getRawData();
        if (n2 > 0 && n4 > n2) {
            throw new SnmpCoderException(SnmpMessageProcessor.a("\u0010v5Od\u0019v9\u0000d\u0011r#\u0006057\b\u0019'8r)\u0004 u") + n4 + ">" + n2 + ")");
        }
        return new SnmpBuffer(byArray, n3, n4);
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 93;
                    break;
                }
                case 1: {
                    n4 = 23;
                    break;
                }
                case 2: {
                    n4 = 77;
                    break;
                }
                case 3: {
                    n4 = 97;
                    break;
                }
                default: {
                    n4 = 68;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }
}

