/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp.engine;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import monfox.log.Logger;
import monfox.toolkit.snmp.Snmp;
import monfox.toolkit.snmp.engine.SnmpBuffer;
import monfox.toolkit.snmp.engine.SnmpCoderException;
import monfox.toolkit.snmp.engine.SnmpEngineID;
import monfox.toolkit.snmp.engine.SnmpErrorListener;
import monfox.toolkit.snmp.engine.SnmpMessage;
import monfox.toolkit.snmp.engine.SnmpMessageListener;
import monfox.toolkit.snmp.engine.SnmpMessageProcessor;
import monfox.toolkit.snmp.engine.SnmpPDU;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.engine.TransportEntity;
import monfox.toolkit.snmp.engine.TransportProvider;
import monfox.toolkit.snmp.engine.b;
import monfox.toolkit.snmp.engine.c;
import monfox.toolkit.snmp.engine.d;
import monfox.toolkit.snmp.metadata.SnmpMetadata;

public class SnmpEngine
implements Serializable {
    static final long serialVersionUID = -507892421245852147L;
    long a;
    int b;
    int c;
    int d;
    int e;
    int f;
    int g;
    private static Logger h = null;
    private int i;
    private SnmpMessageListener j;
    private SnmpMessageListener k;
    private SnmpMessageListener l;
    private SnmpErrorListener m;
    private SnmpEngineID n;
    private int o;
    private SnmpMessageProcessor p;
    private Vector q;
    Monitor r;

    public SnmpEngine() {
        this(null, null);
    }

    public SnmpEngine(SnmpMetadata snmpMetadata) {
        this(null, snmpMetadata);
    }

    public SnmpEngine(SnmpEngineID snmpEngineID) {
        this(snmpEngineID, null);
    }

    public SnmpEngine(SnmpEngineID snmpEngineID, SnmpMetadata snmpMetadata) {
        block5: {
            block4: {
                this.a = -1L;
                this.b = 0;
                this.c = 0;
                this.d = 0;
                this.e = 0;
                this.f = 0;
                this.g = 0;
                this.i = Snmp.DEFAULT_MAX_SIZE;
                this.j = null;
                this.k = null;
                this.l = null;
                this.m = null;
                this.n = null;
                this.o = 9999;
                this.p = null;
                this.q = new Vector();
                this.r = null;
                if (snmpEngineID != null && snmpEngineID.getValue().length != 0) break block4;
                this.n = null;
                if (!SnmpPDU.i) break block5;
            }
            this.n = snmpEngineID;
        }
        this.p = new SnmpMessageProcessor(this, snmpMetadata);
        this.a = System.currentTimeMillis();
        if (h == null) {
            h = Logger.getInstance(SnmpEngine.a("Y\u0018_\u0003fd\u0011[\u001dF"));
        }
    }

    public SnmpMessageProcessor getMessageProcessor() {
        return this.p;
    }

    public void addEventListener(SnmpMessageListener snmpMessageListener) {
        this.l = monfox.toolkit.snmp.engine.c.add(this.l, snmpMessageListener);
    }

    public void removeEventListener(SnmpMessageListener snmpMessageListener) {
        this.l = monfox.toolkit.snmp.engine.c.remove(this.l, snmpMessageListener);
    }

    public boolean containsEventListener(SnmpMessageListener snmpMessageListener) {
        return monfox.toolkit.snmp.engine.c.contains(this.l, snmpMessageListener);
    }

    public void addRequestListener(SnmpMessageListener snmpMessageListener) {
        this.j = monfox.toolkit.snmp.engine.c.add(this.j, snmpMessageListener);
    }

    public void removeRequestListener(SnmpMessageListener snmpMessageListener) {
        this.j = monfox.toolkit.snmp.engine.c.remove(this.j, snmpMessageListener);
    }

    public boolean containsRequestListener(SnmpMessageListener snmpMessageListener) {
        return monfox.toolkit.snmp.engine.c.contains(this.j, snmpMessageListener);
    }

    public void addResponseListener(SnmpMessageListener snmpMessageListener) {
        this.k = monfox.toolkit.snmp.engine.c.add(this.k, snmpMessageListener);
    }

    public void removeResponseListener(SnmpMessageListener snmpMessageListener) {
        this.k = monfox.toolkit.snmp.engine.c.remove(this.k, snmpMessageListener);
    }

    public boolean containsResponseListener(SnmpMessageListener snmpMessageListener) {
        return monfox.toolkit.snmp.engine.c.contains(this.k, snmpMessageListener);
    }

    public void addErrorListener(SnmpErrorListener snmpErrorListener) {
        this.m = monfox.toolkit.snmp.engine.b.add(this.m, snmpErrorListener);
    }

    public void removeErrorListener(SnmpErrorListener snmpErrorListener) {
        this.m = monfox.toolkit.snmp.engine.b.remove(this.m, snmpErrorListener);
    }

    public boolean containsErrorListener(SnmpErrorListener snmpErrorListener) {
        return monfox.toolkit.snmp.engine.b.contains(this.m, snmpErrorListener);
    }

    public void dispatchMessage(TransportEntity transportEntity, SnmpMessage snmpMessage) {
        SnmpPDU snmpPDU = snmpMessage.getData();
        SnmpMessageListener snmpMessageListener = null;
        switch (snmpPDU.getType()) {
            case 162: {
                snmpMessageListener = this.k;
                break;
            }
            case 164: 
            case 166: 
            case 167: {
                snmpMessageListener = this.l;
                break;
            }
            default: {
                snmpMessageListener = this.j;
            }
        }
        if (snmpMessageListener != null) {
            try {
                snmpMessageListener.handleMessage(snmpMessage, transportEntity);
            }
            catch (RuntimeException runtimeException) {
                h.debug(SnmpEngine.a("n\u001fA\u0003B~\u0015Z>Fy\u0005S\u0014F"), runtimeException);
            }
        }
    }

    public void dispatchSecurityError(SnmpBuffer snmpBuffer, TransportEntity transportEntity, int n2, int n3, SnmpCoderException snmpCoderException) {
        if (this.m != null) {
            try {
                this.m.handleError(snmpBuffer, transportEntity, n2, n3, snmpCoderException);
            }
            catch (RuntimeException runtimeException) {
                h.debug(SnmpEngine.a("n\u001fA\u0003B~\u0015Z6Qx\u0019@"), runtimeException);
            }
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void send(SnmpMessage snmpMessage, TransportEntity transportEntity) throws SnmpTransportException, SnmpCoderException {
        Object object;
        boolean bl2 = SnmpPDU.i;
        TransportProvider transportProvider = transportEntity.getProvider();
        if (transportProvider == null) {
            Enumeration enumeration = this.q.elements();
            boolean bl3 = true;
            block0: do {
                if (bl3 && !(bl3 = false) && !bl2) continue;
                object = (TransportProvider)enumeration.nextElement();
                while (((TransportProvider)object).getTransportType() == transportEntity.getTransportType()) {
                    transportProvider = object;
                    if (bl2) continue;
                    if (!bl2) break block0;
                }
            } while (enumeration.hasMoreElements());
        }
        if (transportProvider == null) {
            throw new SnmpTransportException(SnmpEngine.a("D\u0019\u0012#Qe\u0000[\u0017FxVt\u001cVd\u0012\u001c"));
        }
        int n2 = transportEntity.getMaxSize();
        if (n2 <= 0) {
            n2 = this.getMaxSize();
        }
        if (snmpMessage.getMaxSize() < 484) {
            snmpMessage.setMaxSize(this.getMaxSize());
        }
        if (h.isDebugEnabled()) {
            h.debug(SnmpEngine.a("O8q<gC8uSpD;bSnY1\b") + snmpMessage);
        }
        object = this.p.encodeMessage(snmpMessage, n2);
        if (this.r != null) {
            this.r.outgoingMessage(snmpMessage, (SnmpBuffer)object, transportEntity);
        }
        transportProvider.send(object, transportEntity);
    }

    public Thread addTransportProvider(TransportProvider transportProvider) {
        d d2 = new d(this, transportProvider);
        this.q.addElement(transportProvider);
        if (h.isDebugEnabled()) {
            h.debug(SnmpEngine.a("K\u0012V\u0016G*\"@\u0012My\u0006]\u0001WZ\u0004]\u0005Jn\u0013@[") + transportProvider + ")");
        }
        Thread thread = new Thread(d2);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public void removeTransportProvider(TransportProvider transportProvider) {
        if (h.isDebugEnabled()) {
            h.debug(SnmpEngine.a("X\u0013_\u001cUc\u0018USwx\u0017\\\u0000Se\u0004F#Qe\u0000[\u0017Fx^") + transportProvider + ")");
        }
        this.q.removeElement(transportProvider);
        try {
            transportProvider.shutdown();
        }
        catch (SnmpTransportException snmpTransportException) {
            h.debug(SnmpEngine.a("^\u0004S\u001dPz\u0019@\u0007sx\u0019D\u001aGo\u0004\u001c\u0000K\u007f\u0002V\u001cTd^\u001bSFr\u0015W\u0003Wc\u0019\\"), snmpTransportException);
        }
    }

    public Enumeration getTransportProviders() {
        return this.q.elements();
    }

    public int getSnmpInPkts() {
        return this.c;
    }

    public int getSnmpInASNParseErrs() {
        return this.d;
    }

    public int getSnmpInBadVersions() {
        return this.e;
    }

    public int getSnmpSilentDrops() {
        return this.f;
    }

    public int getSnmpProxyDrops() {
        return this.g;
    }

    public void incSnmpInBadVersions() {
        ++this.e;
    }

    public int getSysUpTime() {
        return (int)((System.currentTimeMillis() - this.a) / 10L);
    }

    public void setMaxSize(int n2) {
        this.i = n2;
    }

    public int getMaxSize() {
        return this.i;
    }

    public SnmpEngineID getEngineID() {
        return this.n;
    }

    public int getEngineBoots() {
        return this.o;
    }

    public void setEngineBoots(int n2) {
        this.o = n2;
    }

    public void setEngineTime(int n2) {
        this.a = System.currentTimeMillis();
        this.b = n2;
    }

    public int getEngineTime() {
        return this.b + this.getSysUpTime() / 100;
    }

    public void initEngineBoots(String string) throws IOException, NumberFormatException {
        Object object;
        Object object2;
        try {
            object2 = new FileInputStream(string);
            object = new Properties();
            ((Properties)object).load((InputStream)object2);
            ((FileInputStream)object2).close();
            int n2 = Integer.parseInt(((Properties)object).getProperty(SnmpEngine.a("o\u0018U\u001aMo4]\u001cWy"), "1"));
            this.o = n2 + 1;
            h.debug(SnmpEngine.a("F9s7fNVw=dC8wSaE9f \u0019*") + this.o);
        }
        catch (Exception exception) {
            this.o = 1;
        }
        object2 = new Properties();
        ((Properties)object2).setProperty(SnmpEngine.a("o\u0018U\u001aMo4]\u001cWy"), "" + this.o);
        object = new FileOutputStream(string);
        ((Properties)object2).save((OutputStream)object, SnmpEngine.a("Y\u0018_\u0003\u0003O\u0018U\u001aMoV{\u001dEe"));
        ((FileOutputStream)object).close();
    }

    public void setMonitor(Monitor monitor) {
        this.r = monitor;
    }

    public Monitor getMonitor() {
        return this.r;
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 10;
                    break;
                }
                case 1: {
                    n4 = 118;
                    break;
                }
                case 2: {
                    n4 = 50;
                    break;
                }
                case 3: {
                    n4 = 115;
                    break;
                }
                default: {
                    n4 = 35;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }

    public static interface Monitor {
        public void outgoingMessage(SnmpMessage var1, SnmpBuffer var2, TransportEntity var3);

        public void incomingMessage(SnmpMessage var1, SnmpBuffer var2, TransportEntity var3, String var4);
    }
}

