/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp;

import java.io.Serializable;
import java.math.BigInteger;
import monfox.toolkit.snmp.SnmpCounter;
import monfox.toolkit.snmp.SnmpCounter64;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpGauge;
import monfox.toolkit.snmp.SnmpInt;
import monfox.toolkit.snmp.SnmpIpAddress;
import monfox.toolkit.snmp.SnmpNull;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpOpaque;
import monfox.toolkit.snmp.SnmpString;
import monfox.toolkit.snmp.SnmpTimeTicks;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.metadata.RangeItem;
import monfox.toolkit.snmp.metadata.SnmpDisplayHint;
import monfox.toolkit.snmp.metadata.SnmpMetadata;
import monfox.toolkit.snmp.metadata.SnmpObjectInfo;
import monfox.toolkit.snmp.metadata.SnmpOidInfo;
import monfox.toolkit.snmp.metadata.SnmpTypeInfo;
import monfox.toolkit.snmp.util.StringUtil;

public abstract class SnmpValue
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4622445462948731120L;
    private static final String a = "$Id: SnmpValue.java,v 1.29 2003/12/30 17:47:12 sking Exp $";

    protected SnmpValue() {
    }

    public SnmpValue cloneSnmpValue() {
        try {
            return (SnmpValue)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract String getTypeName();

    public abstract int getType();

    public SnmpOid toIndexOid() {
        return this.toIndexOid(false);
    }

    public abstract SnmpOid toIndexOid(boolean var1);

    public int fromIndexOid(SnmpOid snmpOid, int n2) throws SnmpValueException {
        return this.fromIndexOid(snmpOid, n2, false);
    }

    public abstract int fromIndexOid(SnmpOid var1, int var2, boolean var3) throws SnmpValueException;

    public void appendIndexOid(SnmpOid snmpOid) {
        this.appendIndexOid(snmpOid, false);
    }

    public abstract void appendIndexOid(SnmpOid var1, boolean var2);

    public SnmpOid toIndexOid(SnmpOid snmpOid) {
        SnmpOid snmpOid2 = new SnmpOid(snmpOid);
        this.appendIndexOid(snmpOid2);
        return snmpOid2;
    }

    public SnmpOid toIndexOid(SnmpOid snmpOid, boolean bl2) {
        SnmpOid snmpOid2 = new SnmpOid(snmpOid);
        this.appendIndexOid(snmpOid2, bl2);
        return snmpOid2;
    }

    public abstract long longValue();

    public boolean booleanValue() {
        return this.longValue() != 0L;
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public byte byteValue() {
        return (byte)this.longValue();
    }

    public String getString() {
        return this.toString();
    }

    public long[] toLongArray() {
        return new long[]{this.longValue()};
    }

    public abstract void toString(StringBuffer var1);

    public int getTypeId() {
        return this.getTag();
    }

    public String getTypeShortString() {
        return SnmpValue.typeToShortString(this.getTag());
    }

    public String getTypeString() {
        return SnmpValue.typeToString(this.getTag());
    }

    public static String typeToShortString(int n2) {
        switch (n2) {
            case 2: {
                return "i";
            }
            case 4: {
                return "s";
            }
            case 6: {
                return "o";
            }
            case 5: {
                return "n";
            }
            case 65: {
                return "c";
            }
            case 64: {
                return SnmpValue.a("}j");
            }
            case 67: {
                return "t";
            }
            case 66: {
                return "g";
            }
            case 70: {
                return SnmpValue.a("w,X");
            }
            case 68: {
                return SnmpValue.a("{j");
            }
            case 255: {
                return SnmpValue.a("qt\u00189\u0003");
            }
        }
        return "?";
    }

    public static String typeToString(int n2) {
        switch (n2) {
            case 2: {
                return SnmpValue.a("]T8\u000e=QH");
            }
            case 4: {
                return SnmpValue.a("[Y8\u000e.4I8\u00193Z]");
            }
            case 6: {
                return SnmpValue.a("[X&\u000e9@:%\u000f?ZN%\r3QH");
            }
            case 5: {
                return SnmpValue.a("Zo\u0000'");
            }
            case 65: {
                return SnmpValue.a("Wu\u0019%\u000eqh");
            }
            case 64: {
                return SnmpValue.a("]j-/\u001ef\u007f\u001f8");
            }
            case 67: {
                return SnmpValue.a("@s\u0001..}y\u00078");
            }
            case 66: {
                return SnmpValue.a("S{\u0019,\u001f");
            }
            case 70: {
                return SnmpValue.a("Wu\u0019%\u000eqhZ\u007f");
            }
            case 68: {
                return SnmpValue.a("[j\r:\u000fq");
            }
            case 255: {
                return SnmpValue.a("Qt\u00189\u0003");
            }
        }
        return "?";
    }

    public static int stringToType(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith(SnmpValue.a("}j"))) {
            return 64;
        }
        if (string2.startsWith("i")) {
            return 2;
        }
        if (string2.startsWith("g")) {
            return 66;
        }
        if (string2.startsWith("c") && string2.endsWith(SnmpValue.a("\"."))) {
            return 70;
        }
        if (string2.startsWith("c")) {
            return 65;
        }
        if (string2.startsWith(SnmpValue.a("{j"))) {
            return 68;
        }
        if (string2.startsWith("o")) {
            return 6;
        }
        if (string2.startsWith("t")) {
            return 67;
        }
        if (string2.startsWith("s")) {
            return 4;
        }
        if (string2.startsWith("n")) {
            return 5;
        }
        if (string2.startsWith("e")) {
            return 255;
        }
        return -1;
    }

    public abstract void fromString(String var1) throws SnmpValueException;

    public static SnmpValue getInstance(SnmpOid snmpOid, long l2) throws SnmpValueException {
        SnmpOidInfo snmpOidInfo = snmpOid.getOidInfo();
        if (snmpOidInfo == null) {
            throw new SnmpValueException(SnmpValue.a("zuL$\u0013p:%%\u001c{:\n$\b.:") + snmpOid);
        }
        if (!(snmpOidInfo instanceof SnmpObjectInfo)) {
            throw new SnmpValueException(SnmpValue.a("zu\u0018k\u001bz:\u0003)\u0010qy\u0018k\u0019x{\u001f8Z{s\bqZ") + snmpOid);
        }
        SnmpObjectInfo snmpObjectInfo = (SnmpObjectInfo)snmpOidInfo;
        return SnmpValue.a(snmpObjectInfo.getType(), snmpObjectInfo.getTypeInfo(), null, false, snmpOid.getMetadata(), l2);
    }

    public static SnmpValue getInstance(int n2, long l2) throws SnmpValueException {
        return SnmpValue.a(n2, null, null, false, null, l2);
    }

    public static SnmpValue getInstance(SnmpOid snmpOid, String string) throws SnmpValueException {
        return SnmpValue.getInstance(snmpOid, string, false);
    }

    public static SnmpValue getInstance(SnmpOid snmpOid, String string, boolean bl2) throws SnmpValueException {
        SnmpOidInfo snmpOidInfo = snmpOid.getOidInfo();
        if (snmpOidInfo == null) {
            throw new SnmpValueException(SnmpValue.a("zuL$\u0013p:%%\u001c{:\n$\b.:") + snmpOid);
        }
        if (!(snmpOidInfo instanceof SnmpObjectInfo)) {
            throw new SnmpValueException(SnmpValue.a("zu\u0018k\u001bz:\u0003)\u0010qy\u0018k\u0019x{\u001f8Z{s\bqZ") + snmpOid);
        }
        SnmpObjectInfo snmpObjectInfo = (SnmpObjectInfo)snmpOidInfo;
        return SnmpValue.a(snmpObjectInfo.getType(), snmpObjectInfo.getTypeInfo(), string, bl2, snmpOid.getMetadata());
    }

    public static SnmpValue getInstance(SnmpObjectInfo snmpObjectInfo, String string) throws SnmpValueException {
        return SnmpValue.a(snmpObjectInfo.getType(), snmpObjectInfo.getTypeInfo(), string);
    }

    public static SnmpValue getInstance(SnmpObjectInfo snmpObjectInfo, String string, boolean bl2) throws SnmpValueException {
        return SnmpValue.a(snmpObjectInfo.getType(), snmpObjectInfo.getTypeInfo(), string, bl2, snmpObjectInfo.getMetadata());
    }

    public static SnmpValue getInstance(SnmpTypeInfo snmpTypeInfo, String string) throws SnmpValueException {
        return SnmpValue.a(snmpTypeInfo.getType(), snmpTypeInfo, string);
    }

    public static SnmpValue getInstance(String string, String string2) throws SnmpValueException {
        int n2 = SnmpValue.stringToType(string);
        if (n2 == -1) {
            throw new SnmpValueException(SnmpValue.a("at\u0007%\u0015ctL?\u0003d\u007fVk") + string);
        }
        return SnmpValue.getInstance(n2, string2);
    }

    public static SnmpValue getInstance(int n2, String string) throws SnmpValueException {
        return SnmpValue.a(n2, null, string);
    }

    private static SnmpValue a(int n2, SnmpTypeInfo snmpTypeInfo, String string) throws SnmpValueException {
        return SnmpValue.a(n2, snmpTypeInfo, string, false, null);
    }

    private static SnmpValue a(int n2, SnmpTypeInfo snmpTypeInfo, String string, boolean bl2, SnmpMetadata snmpMetadata) throws SnmpValueException {
        return SnmpValue.a(n2, snmpTypeInfo, string, bl2, snmpMetadata, 0L);
    }

    private static SnmpValue a(int n2, SnmpTypeInfo snmpTypeInfo, String string, boolean bl2, SnmpMetadata snmpMetadata, long l2) throws SnmpValueException {
        switch (n2) {
            case 2: {
                if (string == null) {
                    return new SnmpInt(l2);
                }
                try {
                    if (snmpTypeInfo != null) {
                        try {
                            long l3 = snmpTypeInfo.namedNumberToLong(string);
                            return new SnmpInt(l3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return new SnmpInt(string);
                        }
                    }
                    return new SnmpInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SnmpValueException(SnmpValue.a("}t\u001a*\u0016}~L=\u001bxo\tk\u001c{hL$\u0018~\u007f\u000f?Z`c\u001c.Z") + SnmpValue.typeToString(n2) + SnmpValue.a(".:") + string);
                }
            }
            case 4: {
                Object object;
                if (string == null) {
                    return new SnmpString();
                }
                if (snmpTypeInfo != null && snmpTypeInfo.getSmiType() == 14 && string.startsWith("{") && (object = (Object)snmpTypeInfo.namedBitsStringToBytes(string)) != null) {
                    try {
                        return new SnmpString((byte[])object);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (!bl2) {
                    return new SnmpString(string);
                }
                if (snmpTypeInfo != null && (object = snmpTypeInfo.getSnmpDisplayHint()) != null) {
                    if (string.startsWith("'") && (string.endsWith(SnmpValue.a("3r")) || string.endsWith(SnmpValue.a("3R")) || string.endsWith(SnmpValue.a("3x")) || string.endsWith(SnmpValue.a("3X")))) {
                        return new SnmpString(string);
                    }
                    byte[] byArray = ((SnmpDisplayHint)object).parseString(string = StringUtil.StripQuotes(string));
                    if (byArray != null) {
                        try {
                            return new SnmpString(byArray);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                return new SnmpString(string);
            }
            case 5: {
                return new SnmpNull();
            }
            case 6: {
                if (string == null) {
                    return new SnmpOid(snmpMetadata, SnmpValue.a("$4]"));
                }
                return new SnmpOid(snmpMetadata, string);
            }
            case 64: {
                if (string == null) {
                    return new SnmpIpAddress();
                }
                return new SnmpIpAddress(string);
            }
            case 65: {
                if (string == null) {
                    return new SnmpCounter(l2);
                }
                return new SnmpCounter(string);
            }
            case 70: {
                if (string == null) {
                    return new SnmpCounter64(l2);
                }
                return new SnmpCounter64(string);
            }
            case 66: {
                if (string == null) {
                    return new SnmpGauge(l2);
                }
                return new SnmpGauge(string);
            }
            case 67: {
                if (string == null) {
                    return new SnmpTimeTicks(l2);
                }
                return new SnmpTimeTicks(string);
            }
            case 68: {
                if (string == null) {
                    return new SnmpOpaque();
                }
                return new SnmpOpaque(string);
            }
        }
        throw new SnmpValueException(SnmpValue.a("at\u0007%\u0015ctL?\u0003d\u007fVk") + n2);
    }

    public static boolean validate(SnmpOid snmpOid, SnmpValue snmpValue) throws SnmpValueException {
        SnmpOidInfo snmpOidInfo = snmpOid.getOidInfo();
        if (snmpOid == null) {
            throw new SnmpValueException(SnmpValue.a("zuL$\u0013p:%%\u001c{:\n$\b.:") + snmpOid);
        }
        if (!(snmpOidInfo instanceof SnmpObjectInfo)) {
            throw new SnmpValueException(SnmpValue.a("zu\u0018k\u001bz:\u0003)\u0010qy\u0018k\u0019x{\u001f8Z{s\bqZ") + snmpOid);
        }
        SnmpObjectInfo snmpObjectInfo = (SnmpObjectInfo)snmpOidInfo;
        return SnmpValue.validate(snmpObjectInfo.getType(), snmpValue);
    }

    public static boolean validate(SnmpObjectInfo snmpObjectInfo, SnmpValue snmpValue) {
        return SnmpValue.validate(snmpObjectInfo.getType(), snmpValue);
    }

    public static boolean validate(int n2, SnmpValue snmpValue) {
        return n2 == snmpValue.getType();
    }

    public static int validate(SnmpTypeInfo snmpTypeInfo, SnmpValue snmpValue) {
        int n2;
        block7: {
            boolean bl2;
            block9: {
                RangeItem[] rangeItemArray;
                block8: {
                    n2 = snmpTypeInfo.getType();
                    if (n2 != snmpValue.getType()) {
                        return 7;
                    }
                    if (!snmpTypeInfo.hasRangeSpec()) break block7;
                    rangeItemArray = snmpTypeInfo.getRangeSpec();
                    bl2 = true;
                    if (n2 != 2 && n2 != 66) break block8;
                    bl2 = SnmpValue.a(rangeItemArray, snmpValue.longValue());
                    if (!SnmpException.b) break block9;
                }
                if (n2 == 4 || n2 == 68) {
                    bl2 = SnmpValue.a(rangeItemArray, snmpValue.getByteArray().length);
                }
            }
            if (!bl2) {
                return 10;
            }
        }
        if (n2 == 2 && snmpTypeInfo.getNumberToNameMap() != null && snmpTypeInfo.intToNamedNumber(snmpValue.longValue()) == null) {
            return 10;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean a(RangeItem[] var0, long var1_1) {
        var4_2 = SnmpException.b;
        var3_3 = 0;
        if (!var4_2) ** GOTO lbl10
        block0: while (true) {
            v0 = var0[var3_3].isSingle();
            do {
                if (v0 != false ? var0[var3_3].getSingleValue() == var1_1 : var0[var3_3].getLowerValue() <= var1_1 && var0[var3_3].getUpperValue() >= var1_1) {
                    return true;
                }
                ++var3_3;
lbl10:
                // 2 sources

                if (var3_3 < var0.length) continue block0;
                v0 = false;
            } while (var4_2);
            break;
        }
        return v0;
    }

    public String toString(SnmpOid snmpOid) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, snmpOid, false);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer, SnmpOid snmpOid, boolean bl2) {
        block3: {
            block2: {
                SnmpOid snmpOid2 = snmpOid;
                if (snmpOid2 == null || snmpOid2.getOidInfo() == null || !(snmpOid2.getOidInfo() instanceof SnmpObjectInfo)) break block2;
                SnmpObjectInfo snmpObjectInfo = (SnmpObjectInfo)snmpOid2.getOidInfo();
                this.toString(stringBuffer, snmpObjectInfo, bl2);
                if (!SnmpException.b) break block3;
            }
            this.toString(stringBuffer, (SnmpObjectInfo)null, bl2);
        }
    }

    public void toString(StringBuffer stringBuffer, SnmpObjectInfo snmpObjectInfo, boolean bl2) {
        if (snmpObjectInfo != null) {
            SnmpObjectInfo snmpObjectInfo2 = snmpObjectInfo;
            SnmpTypeInfo snmpTypeInfo = snmpObjectInfo2.getTypeInfo();
            if (snmpTypeInfo != null) {
                SnmpDisplayHint snmpDisplayHint = snmpTypeInfo.getSnmpDisplayHint();
                if (this instanceof SnmpInt) {
                    long l2 = this.longValue();
                    String string = snmpTypeInfo.intToNamedNumber(l2);
                    if (string != null) {
                        stringBuffer.append(string);
                        if (!bl2) {
                            stringBuffer.append("(").append(l2).append(")");
                        }
                        return;
                    }
                    if (snmpDisplayHint != null) {
                        snmpDisplayHint.format(stringBuffer, l2);
                        return;
                    }
                } else if (this.getByteArray() != null) {
                    if (snmpTypeInfo.getSmiType() == 14 && (snmpTypeInfo.getNameToNumberMap() != null || snmpDisplayHint == null)) {
                        snmpTypeInfo.bytesToNamedBitsString(stringBuffer, this.getByteArray());
                        return;
                    }
                    if (snmpDisplayHint != null) {
                        snmpDisplayHint.format(stringBuffer, this.getByteArray());
                        return;
                    }
                }
            } else if (snmpObjectInfo2.getSmiType() == 14 && this instanceof SnmpString) {
                stringBuffer.append(((SnmpString)this).toHexString());
                return;
            }
        }
        this.toString(stringBuffer);
    }

    public int getTag() {
        return -1;
    }

    public int getCoder() {
        return -1;
    }

    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLongValue());
    }

    public long getLongValue() {
        return 0L;
    }

    public byte[] getByteArray() {
        return null;
    }

    public long[] getLongArray() {
        return null;
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 20;
                    break;
                }
                case 1: {
                    n4 = 26;
                    break;
                }
                case 2: {
                    n4 = 108;
                    break;
                }
                case 3: {
                    n4 = 75;
                    break;
                }
                default: {
                    n4 = 122;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }
}

