/*
 * Decompiled with CFR 0.152.
 */
package monfox.toolkit.snmp;

import java.math.BigInteger;
import monfox.toolkit.snmp.SnmpInt;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;

public class SnmpCounter64
extends SnmpValue {
    static final long serialVersionUID = -5998111581982421757L;
    public static final BigInteger MAX_U64 = new BigInteger(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1});
    private BigInteger a;
    private static final String b = "$Id: SnmpCounter64.java,v 1.18 2003/09/23 21:06:55 sking Exp $";

    public SnmpCounter64() throws IllegalArgumentException {
        this.a = BigInteger.ZERO;
    }

    public SnmpCounter64(SnmpCounter64 snmpCounter64) {
        this.a = snmpCounter64.a;
    }

    public SnmpCounter64(long l2) throws IllegalArgumentException {
        this.a = this.a(l2);
    }

    public SnmpCounter64(Long l2) throws IllegalArgumentException {
        this.a = this.a(l2);
    }

    public SnmpCounter64(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger.compareTo(MAX_U64) > 0) {
            bigInteger = bigInteger.and(MAX_U64);
        }
        this.a = bigInteger;
    }

    public SnmpCounter64(String string) throws SnmpValueException {
        this.fromString(string);
    }

    public synchronized void fromString(String string) throws SnmpValueException {
        try {
            BigInteger bigInteger = new BigInteger(string);
            if (bigInteger.compareTo(MAX_U64) > 0) {
                bigInteger = bigInteger.and(MAX_U64);
            }
            this.a = bigInteger;
        }
        catch (Exception exception) {
            throw new SnmpValueException(SnmpCounter64.a("PD\u0017\u0014\\pNA6_lD\u0015\u0010B/\u001eAR") + string + "'");
        }
    }

    public final synchronized Object clone() {
        return new SnmpCounter64(this.a);
    }

    public final String getTypeName() {
        return SnmpCounter64.a("ZE\u0014\u001bD|XWA");
    }

    public synchronized byte byteValue() {
        return (byte)this.a.intValue();
    }

    public synchronized int intValue() {
        return this.a.intValue();
    }

    public synchronized long longValue() {
        return this.a.longValue();
    }

    public synchronized boolean booleanValue() {
        return this.a.longValue() != 0L;
    }

    public Integer toInteger() {
        return new Integer(this.a.intValue());
    }

    public Long toLong() {
        return new Long(this.a.longValue());
    }

    public BigInteger toBigInteger() {
        return this.a;
    }

    public SnmpOid toIndexOid(boolean bl2) {
        return new SnmpOid(this.a.longValue());
    }

    public void appendIndexOid(SnmpOid snmpOid, boolean bl2) {
        snmpOid.append(this.a.longValue());
    }

    public int fromIndexOid(SnmpOid snmpOid, int n2, boolean bl2) throws SnmpValueException {
        if (n2 + 1 > snmpOid.getLength()) {
            throw new SnmpValueException(SnmpCounter64.a("jB\u000e\u0007D9C\u000f\u0011Ua\u0010") + snmpOid);
        }
        long l2 = snmpOid.get(n2);
        this.a = this.a(l2);
        return n2 + 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.a.toString());
    }

    public boolean equals(Object object) {
        try {
            return this.compareTo(object) == 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        if (object instanceof SnmpCounter64) {
            return this.a.compareTo(((SnmpCounter64)object).a);
        }
        if (object instanceof SnmpInt) {
            return this.compareTo(((SnmpInt)object).longValue());
        }
        if (object instanceof Number) {
            return this.compareTo(((Number)object).longValue());
        }
        throw new ClassCastException(SnmpCounter64.a("WE\u0015UQw\n2\u001b]ii\u000e\u0000^mO\u0013C\u0004ey\u000f\u0018@PD\u0015\t~lG\u0003\u0010B"));
    }

    public int compareTo(long l2) {
        long l3 = this.a.longValue();
        if (l3 < l2) {
            return -1;
        }
        if (l3 > l2) {
            return 1;
        }
        return 0;
    }

    public long getLongValue() {
        return this.a.longValue();
    }

    public BigInteger getUnsignedValue() {
        return this.a;
    }

    public BigInteger getBigInteger() {
        return this.a;
    }

    private BigInteger a(long l2) {
        if (l2 >= 0L) {
            return BigInteger.valueOf(l2);
        }
        return MAX_U64.add(BigInteger.valueOf(l2 + 1L));
    }

    public int getType() {
        return 70;
    }

    public int getTag() {
        return 70;
    }

    public int getCoder() {
        return 7;
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 25;
                    break;
                }
                case 1: {
                    n4 = 42;
                    break;
                }
                case 2: {
                    n4 = 97;
                    break;
                }
                case 3: {
                    n4 = 117;
                    break;
                }
                default: {
                    n4 = 48;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }
}

