/*
 * Decompiled with CFR 0.152.
 */
package monfox.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import monfox.jdom.DataConversionException;
import monfox.jdom.Element;
import monfox.jdom.IllegalDataException;
import monfox.jdom.IllegalNameException;
import monfox.jdom.Namespace;
import monfox.jdom.Verifier;

public class Attribute
implements Serializable,
Cloneable {
    protected String name;
    protected transient Namespace namespace;
    protected String value;
    protected Element parent;

    protected Attribute() {
    }

    public Attribute(String string, String string2, Namespace namespace) {
        String string3 = Verifier.checkAttributeName(string);
        if (string3 != null) {
            throw new IllegalNameException(string, Attribute.a("d{\u0007l\u001agz\u0007{"), string3);
        }
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (namespace != Namespace.NO_NAMESPACE && namespace.getPrefix().equals("")) {
            throw new IllegalNameException("", Attribute.a("d{\u0007l\u001agz\u0007{Skn\u001e{\u0000un\u0010{"), Attribute.a("DaS\u007f\u0007q}\u001a|\u0006qjSp\u0012hj\u0000n\u0012fjSi\u001aqg\u001ck\u0007%nSn\u0001`i\u001afSfn\u001d>\u001ckc\n>\u0011`/\u0007v\u0016%A<A=DB6M#DL6>\u001ddb\u0016m\u0003dl\u0016"));
        }
        this.name = string;
        this.setValue(string2);
        this.namespace = namespace;
    }

    public Attribute(String string, String string2, String string3, String string4) {
        this(string, string4, Namespace.getNamespace(string2, string3));
    }

    public Attribute(String string, String string2) {
        this(string, string2, Namespace.NO_NAMESPACE);
    }

    public Element getParent() {
        return this.parent;
    }

    protected Attribute setParent(Element element) {
        this.parent = element;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.namespace.getPrefix();
        if (string != null && !string.equals("")) {
            stringBuffer.append(string).append(":");
        }
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(String string) {
        String string2 = null;
        string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, Attribute.a("d{\u0007l\u001agz\u0007{"), string2);
        }
        this.value = string;
        return this;
    }

    public String toString() {
        return Attribute.a("^N\u0007j\u0001lm\u0006j\u0016?/") + this.getSerializedForm() + "]";
    }

    public final String getSerializedForm() {
        return this.getQualifiedName() + Attribute.a("8-") + this.value + "\"";
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Attribute attribute = new Attribute(this.name, this.value, this.namespace);
        return attribute;
    }

    public int getIntValue() throws DataConversionException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, Attribute.a("la\u0007"));
        }
    }

    public long getLongValue() throws DataConversionException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, Attribute.a("i`\u001dy"));
        }
    }

    public float getFloatValue() throws DataConversionException {
        try {
            return Float.valueOf(this.value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, Attribute.a("cc\u001c\u007f\u0007"));
        }
    }

    public double getDoubleValue() throws DataConversionException {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, Attribute.a("a`\u0006|\u001f`"));
        }
    }

    public boolean getBooleanValue() throws DataConversionException {
        if (this.value.equalsIgnoreCase(Attribute.a("q}\u0006{")) || this.value.equalsIgnoreCase(Attribute.a("ja")) || this.value.equalsIgnoreCase(Attribute.a("|j\u0000"))) {
            return true;
        }
        if (this.value.equalsIgnoreCase(Attribute.a("cn\u001fm\u0016")) || this.value.equalsIgnoreCase(Attribute.a("ji\u0015")) || this.value.equalsIgnoreCase(Attribute.a("k`"))) {
            return false;
        }
        throw new DataConversionException(this.name, Attribute.a("g`\u001cr\u0016da"));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            char c2 = cArray[n5];
            switch (n3 % 5) {
                case 0: {
                    n4 = 5;
                    break;
                }
                case 1: {
                    n4 = 15;
                    break;
                }
                case 2: {
                    n4 = 115;
                    break;
                }
                case 3: {
                    n4 = 30;
                    break;
                }
                default: {
                    n4 = 115;
                }
            }
            cArray[n5] = (char)(c2 ^ n4);
            ++n3;
        }
        return new String(cArray);
    }
}

