/*
 * Decompiled with CFR 0.152.
 */
import com.sanrad.nms.server.user.UserImpl;
import com.sanrad.security.StringCodec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ConvertUsersFile31233 {
    private static final String CODEC_KEY = "The alias ";
    private static final String USERS_FILE_NAME = "users.dat";
    private static final String OLD_USERS_FILE_NAME = "users.dat.31";

    private static Properties loadUsersFromOldFileFormat(File file) throws IOException, ClassNotFoundException {
        Vector usersVector = ConvertUsersFile31233.getUsersVectorFromOldFileFormat(file);
        Properties usersProps = new Properties();
        if (usersVector == null) {
            System.out.println("No users were found in " + file);
            return usersProps;
        }
        if (usersVector.isEmpty()) {
            System.out.println("Users file " + file + " is empty");
            return usersProps;
        }
        Enumeration e = usersVector.elements();
        while (e.hasMoreElements()) {
            UserImpl codeUser = (UserImpl)e.nextElement();
            String password = codeUser.getPassword();
            try {
                String userName = codeUser.getUsername();
                userName = StringCodec.encryptString(CODEC_KEY, userName);
                usersProps.setProperty(userName, password);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
        return usersProps;
    }

    private static Vector getUsersVectorFromOldFileFormat(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + file + " not found. Probbaly no users were defined in the first place.");
            return null;
        }
        Vector usersVector = null;
        if (fis != null) {
            ObjectInputStream in = new ObjectInputStream(fis);
            usersVector = (Vector)in.readObject();
            in.close();
        }
        return usersVector;
    }

    private static void saveUsersPropertiesAndReanmeOldFile(Properties aUsersProps, String fileName) throws IOException {
        if (aUsersProps.isEmpty()) {
            System.out.println("Users not found.");
            return;
        }
        FileOutputStream outFile = new FileOutputStream(fileName);
        aUsersProps.store(outFile, null);
        outFile.flush();
        outFile.close();
    }

    private static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void main(String[] args) {
        File originFile = new File(USERS_FILE_NAME);
        File backupFile = new File(OLD_USERS_FILE_NAME);
        try {
            ConvertUsersFile31233.copy(originFile, backupFile);
            System.out.println("Copied " + originFile + " to " + backupFile);
        }
        catch (IOException e) {
            System.err.println("Failed to copy " + originFile + " to " + backupFile + ". " + e.getMessage());
            System.exit(1);
        }
        Properties usersProps = null;
        try {
            usersProps = ConvertUsersFile31233.loadUsersFromOldFileFormat(originFile);
        }
        catch (Exception e) {
            System.err.println("Failed to get users Vector from old file format" + (e.getMessage() == null ? "" : ": " + e.getMessage()));
            e.printStackTrace();
            System.exit(2);
        }
        if (usersProps != null && !usersProps.isEmpty()) {
            System.out.println("Users were loaded from old format file " + originFile);
            try {
                ConvertUsersFile31233.saveUsersPropertiesAndReanmeOldFile(usersProps, USERS_FILE_NAME);
                System.out.println("Users successfully saved to new format in file users.dat");
            }
            catch (IOException e) {
                System.err.println("Failed to successfully save to new format in file users.dat");
                e.printStackTrace();
            }
        } else {
            System.out.println("No users were saved to new format file");
        }
    }
}

