/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishCBC;
import BlowfishJ.BlowfishECB;
import java.io.IOException;
import java.util.Random;

public class BlowfishTest {
    static final int MAX_MESS_SIZE = 256;
    static final int TESTBUFSIZE = 100000;
    static final int TESTLOOPS = 2000;
    static final long CBCIV_START = -81985529216486896L;

    public static void main(String[] args) {
        byte[] messbuf;
        System.out.print("\nstarting selftest...");
        if (!BlowfishECB.selfTest()) {
            System.out.println(",selftest failed");
            return;
        }
        System.out.println(", passed.");
        Random rand = new Random();
        byte[] testkey = new byte[20];
        for (int nI = 0; nI < 20; ++nI) {
            testkey[nI] = (byte)(rand.nextInt() & 0xFF);
        }
        System.out.print("setting up Blowfish keys...");
        BlowfishECB bfecb = new BlowfishECB(testkey);
        BlowfishCBC bfcbc = new BlowfishCBC(testkey, -81985529216486896L);
        System.out.println(", done.\n");
        System.out.print("something to encrypt please >");
        System.out.flush();
        byte[] tempbuf = new byte[256];
        int nMessSize = 0;
        try {
            nMessSize = System.in.read(tempbuf) - 2;
        }
        catch (IOException ioe) {
            return;
        }
        int nRest = nMessSize & 7;
        if (nRest != 0) {
            messbuf = new byte[(nMessSize & 0xFFFFFFF8) + 8];
            System.arraycopy(tempbuf, 0, messbuf, 0, nMessSize);
            for (int nI = nMessSize; nI < messbuf.length; ++nI) {
                messbuf[nI] = 32;
            }
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("message with ").append(nMessSize).append(" bytes aligned to ").append(messbuf.length).append(" bytes"))));
        } else {
            messbuf = new byte[nMessSize];
            System.arraycopy(tempbuf, 0, messbuf, 0, nMessSize);
        }
        bfecb.encrypt(messbuf);
        System.out.println("ECB encrypted message: ".concat(String.valueOf(String.valueOf(BinConverter.bytesToBinHex(messbuf)))));
        bfecb.decrypt(messbuf);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("ECB decrypted message: >>>").append(new String(messbuf)).append("<<<"))));
        byte[] showIV = new byte[8];
        bfcbc.getCBCIV(showIV);
        System.out.println("CBC IV : ".concat(String.valueOf(String.valueOf(BinConverter.bytesToBinHex(showIV)))));
        bfcbc.encrypt(messbuf);
        System.out.println("CBC encrypted message: ".concat(String.valueOf(String.valueOf(BinConverter.bytesToBinHex(messbuf)))));
        bfcbc.setCBCIV(-81985529216486896L);
        bfcbc.decrypt(messbuf);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("CBC decrypted message: >>>").append(new String(messbuf)).append("<<<"))));
        bfecb.cleanUp();
        bfcbc.cleanUp();
    }

    static {
        MAX_MESS_SIZE = 256;
        TESTBUFSIZE = 100000;
        TESTLOOPS = 2000;
        CBCIV_START = -81985529216486896L;
    }
}

