/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

public class BinConverter {
    static final char[] HEXTAB = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static long byteArrayToLong(byte[] buffer, int nStartIndex) {
        return (long)buffer[nStartIndex] << 56 | ((long)buffer[nStartIndex + 1] & 0xFFL) << 48 | ((long)buffer[nStartIndex + 2] & 0xFFL) << 40 | ((long)buffer[nStartIndex + 3] & 0xFFL) << 32 | ((long)buffer[nStartIndex + 4] & 0xFFL) << 24 | ((long)buffer[nStartIndex + 5] & 0xFFL) << 16 | ((long)buffer[nStartIndex + 6] & 0xFFL) << 8 | (long)buffer[nStartIndex + 7] & (long)255;
    }

    public static void longToByteArray(long lValue, byte[] buffer, int nStartIndex) {
        buffer[nStartIndex] = (byte)(lValue >>> 56);
        buffer[nStartIndex + 1] = (byte)(lValue >>> 48 & (long)255);
        buffer[nStartIndex + 2] = (byte)(lValue >>> 40 & (long)255);
        buffer[nStartIndex + 3] = (byte)(lValue >>> 32 & (long)255);
        buffer[nStartIndex + 4] = (byte)(lValue >>> 24 & (long)255);
        buffer[nStartIndex + 5] = (byte)(lValue >>> 16 & (long)255);
        buffer[nStartIndex + 6] = (byte)(lValue >>> 8 & (long)255);
        buffer[nStartIndex + 7] = (byte)lValue;
    }

    public static long intArrayToLong(int[] buffer, int nStartIndex) {
        return (long)buffer[nStartIndex] << 32 | (long)buffer[nStartIndex + 1] & 0xFFFFFFFFL;
    }

    public static void longToIntArray(long lValue, int[] buffer, int nStartIndex) {
        buffer[nStartIndex] = (int)(lValue >>> 32);
        buffer[nStartIndex + 1] = (int)lValue;
    }

    public static long makeLong(int nLo, int nHi) {
        return (long)nHi << 32 | (long)nLo & 0xFFFFFFFFL;
    }

    public static int longLo32(long lVal) {
        return (int)lVal;
    }

    public static int longHi32(long lVal) {
        return (int)(lVal >>> 32);
    }

    public static String bytesToBinHex(byte[] data) {
        return BinConverter.bytesToBinHex(data, 0, data.length);
    }

    public static String bytesToBinHex(byte[] data, int nStartPos, int nNumOfBytes) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nNumOfBytes << 1);
        int nPos = 0;
        for (int nI = 0; nI < nNumOfBytes; ++nI) {
            sbuf.setCharAt(nPos++, HEXTAB[data[nI + nStartPos] >> 4 & 0xF]);
            sbuf.setCharAt(nPos++, HEXTAB[data[nI + nStartPos] & 0xF]);
        }
        return sbuf.toString();
    }

    public static int binHexToBytes(String sBinHex, byte[] data, int nSrcPos, int nDstPos, int nNumOfBytes) {
        int nOutputCapacity;
        int nStrLen = sBinHex.length();
        int nAvailBytes = nStrLen - nSrcPos >> 1;
        if (nAvailBytes < nNumOfBytes) {
            nNumOfBytes = nAvailBytes;
        }
        if (nNumOfBytes > (nOutputCapacity = data.length - nDstPos)) {
            nNumOfBytes = nOutputCapacity;
        }
        int nResult = 0;
        for (int nI = 0; nI < nNumOfBytes; ++nI) {
            int bActByte = 0;
            boolean blConvertOK = true;
            for (int nJ = 0; nJ < 2; ++nJ) {
                char cActChar;
                bActByte = (byte)(bActByte << 4);
                if ((cActChar = sBinHex.charAt(nSrcPos++)) >= 'a' && cActChar <= 'f') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 97) + 10);
                    continue;
                }
                if (cActChar >= '0' && cActChar <= '9') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 48));
                    continue;
                }
                blConvertOK = false;
            }
            if (!blConvertOK) continue;
            data[nDstPos++] = bActByte;
            ++nResult;
        }
        return nResult;
    }

    public static String byteArrayToUNCString(byte[] data, int nStartPos, int nNumOfBytes) {
        int nAvailCapacity = data.length - nStartPos;
        if (nAvailCapacity < (nNumOfBytes &= 0xFFFFFFFE)) {
            nNumOfBytes = nAvailCapacity;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nNumOfBytes >> 1);
        int nSBufPos = 0;
        while (nNumOfBytes > 0) {
            sbuf.setCharAt(nSBufPos++, (char)(data[nStartPos] << 8 | data[nStartPos + 1] & 0xFF));
            nStartPos += 2;
            nNumOfBytes -= 2;
        }
        return sbuf.toString();
    }
}

