/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;

public class ProcessingInstruction
implements Serializable,
Cloneable {
    protected String target;
    protected String rawData;
    protected Map mapData;
    protected Element parent;
    protected Document document;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String target, String data) {
        String reason = Verifier.checkProcessingInstructionTarget(target);
        if (reason != null) {
            throw new IllegalTargetException(target, reason);
        }
        this.target = target;
        this.setData(data);
    }

    public ProcessingInstruction(String target, Map data) {
        String reason = Verifier.checkProcessingInstructionTarget(target);
        if (reason != null) {
            throw new IllegalTargetException(target, reason);
        }
        this.target = target;
        this.setData(data);
    }

    public Object clone() {
        return new ProcessingInstruction(this.target, this.rawData);
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public String getData() {
        return this.rawData;
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        Element p = this.getParent();
        if (p != null) {
            return p.getDocument();
        }
        return null;
    }

    public Element getParent() {
        return this.parent;
    }

    public final String getSerializedForm() {
        if (!"".equals(this.rawData)) {
            return "<?" + this.target + " " + this.rawData + "?>";
        }
        return "<?" + this.target + "?>";
    }

    public String getTarget() {
        return this.target;
    }

    public String getValue(String name) {
        if (this.mapData.containsKey(name)) {
            return (String)this.mapData.get(name);
        }
        return "";
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private Map parseData(String rawData) {
        HashMap<String, String> data = new HashMap<String, String>();
        StringTokenizer s = new StringTokenizer(rawData);
        while (s.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(s.nextToken(), "='\"");
            if (t.countTokens() < 2) continue;
            String name = t.nextToken();
            String value = t.nextToken();
            data.put(name, value);
        }
        return data;
    }

    public boolean removeValue(String name) {
        if (this.mapData.remove(name) != null) {
            this.rawData = this.toString(this.mapData);
            return true;
        }
        return false;
    }

    public ProcessingInstruction setData(String data) {
        this.rawData = data;
        this.mapData = this.parseData(data);
        return this;
    }

    public ProcessingInstruction setData(Map data) {
        this.rawData = this.toString(data);
        this.mapData = data;
        return this;
    }

    protected ProcessingInstruction setDocument(Document document) {
        this.document = document;
        return this;
    }

    protected ProcessingInstruction setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public ProcessingInstruction setValue(String name, String value) {
        this.mapData.put(name, value);
        this.rawData = this.toString(this.mapData);
        return this;
    }

    public String toString() {
        return "[Processing Instruction: " + this.getSerializedForm() + "]";
    }

    private String toString(Map mapData) {
        StringBuffer rawData = new StringBuffer();
        Iterator i = mapData.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)mapData.get(name);
            rawData.append(name).append("=\"").append(value).append("\" ");
        }
        rawData.setLength(rawData.length() - 1);
        return rawData.toString();
    }
}

