/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishCBC;
import BlowfishJ.SHA1;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public class BlowfishOutputStream
extends OutputStream {
    private OutputStream _out;
    private String _passphrase;
    private BlowfishCBC _cbc;
    private long _iv;
    byte[] _in_buffer;
    byte[] _out_buffer;
    int _bytes_in_buffer = 0;
    boolean _started = false;

    public BlowfishOutputStream(String passphrase, OutputStream os) {
        this._passphrase = passphrase;
        this._out = os;
        SHA1 hasher = new SHA1();
        hasher.update(this._passphrase);
        hasher.finalize();
        this._cbc = new BlowfishCBC(hasher.getDigest(), 0L);
        hasher.clear();
        this._iv = new Random().nextLong();
        this._in_buffer = new byte[8];
        this._out_buffer = new byte[8];
    }

    public void write(int b) throws IOException {
        if (!this._started) {
            byte[] iv_bytes = new byte[8];
            BinConverter.longToByteArray(this._iv, iv_bytes, 0);
            this._out.write(iv_bytes, 0, iv_bytes.length);
            this._cbc.setCBCIV(this._iv);
            this._started = true;
        }
        ++this._bytes_in_buffer;
        if (this._bytes_in_buffer < this._in_buffer.length) {
            this._in_buffer[this._bytes_in_buffer - 1] = (byte)b;
            return;
        }
        this._in_buffer[this._bytes_in_buffer - 1] = (byte)b;
        this._bytes_in_buffer = 0;
        this._cbc.encrypt(this._in_buffer, this._out_buffer);
        for (int i = 0; i < this._out_buffer.length; ++i) {
            this._out.write(this._out_buffer[i]);
        }
    }

    public void close() throws IOException {
        byte pad_val = (byte)(this._in_buffer.length - this._bytes_in_buffer);
        if (pad_val > 0) {
            while (this._bytes_in_buffer < this._in_buffer.length) {
                this._in_buffer[this._bytes_in_buffer] = pad_val;
                ++this._bytes_in_buffer;
            }
            this._cbc.encrypt(this._in_buffer, this._out_buffer);
            for (int i = 0; i < this._out_buffer.length; ++i) {
                this._out.write(this._out_buffer[i]);
            }
        }
        this.flush();
        this._out.close();
        this._cbc.cleanUp();
    }

    public void flush() throws IOException {
        this._out.flush();
    }
}

