/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.wizard;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationErrorEvent;
import com.sanrad.nms.client.comm.CommunicationErrorListener;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrComponentStatusBarInterface;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.jwf.Wizard;
import com.sanrad.swing.jwf.WizardListener;
import com.sanrad.swing.jwf.WizardTransactionMonitor;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class SrWizardFrame
extends JFrame
implements WizardListener,
SrComponentStatusBarInterface,
PropertyPanelValidationListener,
CommunicationErrorListener,
ClusterListener,
OperationController,
WizardTransactionMonitor {
    public static final int HEIGHT_EXTENSION = 15;
    private static SrLogger theLogger = SrLogger.getExternalPackageLogger();
    private static final HashMap runningWizards = new HashMap();
    private Wizard m_wiz;
    private SrWizardPanel m_firstPanel;
    protected String m_wizTitle;
    protected SrComponentStatusBarPanel m_statusPanel;
    private MouseAdapter emptyMouseListener = new MouseAdapter(){};
    private static final String SPACE = " ";
    public static final ContextKey OWNER_KEY = new ContextKey(){};
    private ArrayList m_involvedClusterList = new ArrayList();

    protected SrWizardFrame(JFrame owner, String wizTitle, ImageIcon aWizardImage) {
        this(owner, wizTitle, null, aWizardImage);
    }

    protected SrWizardFrame(JFrame owner, String wizTitle, SrWizardPanel panel) {
        this(owner, wizTitle, panel, null);
    }

    protected SrWizardFrame(JFrame owner, String wizTitle, SrWizardPanel panel, ImageIcon aWizardImage) {
        Util.validateInputNotNull(owner, "Wizard owner window");
        this.setIconImage(ImageObject.APP_ICON.getImageIcon().getImage());
        this.m_firstPanel = panel;
        this.setResizable(false);
        CommunicationEventService.getInstance().addCommunicationErrorListener(this);
        ClusterManager.getInstance().addClusterListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SrWizardFrame.this.onWizardWindowClose();
            }
        });
        this.m_wiz = new Wizard(aWizardImage);
        this.m_statusPanel = this.m_wiz.getStatusBarPanel();
        this.m_wiz.addWizardListener(this);
        this.getContentPane().add(this.m_wiz);
        this.m_wiz.setTransactionMonitor(this);
        this.m_wizTitle = wizTitle + SPACE;
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected void setFirstPanel(SrWizardPanel panel) {
        this.m_firstPanel = panel;
    }

    public void runWizard() {
        runningWizards.put(this.getClass(), this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SrAction.updateAllActions();
                SrWizardFrame.this.setVisible(true);
            }
        });
        this.m_wiz.start(this.m_firstPanel, this);
    }

    protected void onWizardWindowClose() {
        this.verifyClose();
    }

    @Override
    public void wizardCancelled(EventObject event) {
        this.verifyClose();
    }

    private void verifyClose() {
        int answer = SrOptionPaneUtil.showYesNoConfirmDialog(this, this.getClosingMessage(), this.getTitle());
        if (answer == 0) {
            this.dispose();
        }
    }

    protected abstract String getClosingMessage();

    protected abstract String getFinishMessage();

    @Override
    public void wizardFinished(EventObject event) {
        this.dispose();
    }

    @Override
    public void wizardPanelChanged(EventObject event) {
        Wizard wizard = (Wizard)event.getSource();
        if (wizard.getCurrentPanel() != null) {
            this.setTitle(this.m_wizTitle);
            this.m_statusPanel.setStatusStr("");
        }
    }

    public SrComponentStatusBarPanel getStatusBarPanel() {
        return this.m_statusPanel;
    }

    @Override
    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        if (e == null) {
            this.m_statusPanel.setStatusStr("");
        } else {
            Vector nonValidFields = e.getNonValidFields();
            boolean valid = nonValidFields.isEmpty();
            if (valid) {
                this.m_statusPanel.setStatusStr("");
            } else {
                this.m_statusPanel.setStatusStr("Please fill the missing data marked by the red asterisks");
            }
        }
    }

    public void addParticipatingCluster(ClusterNode cluster) {
        if (cluster != null && !this.m_involvedClusterList.contains(cluster)) {
            this.m_involvedClusterList.add(cluster);
        }
    }

    public void removeParticipatingCluster(ClusterNode cluster) {
        this.m_involvedClusterList.remove(cluster);
    }

    public void clearParticipatingClusters() {
        this.m_involvedClusterList.clear();
    }

    private void disableUserInput() {
        this.getGlassPane().addMouseListener(this.emptyMouseListener);
        this.getGlassPane().setVisible(true);
    }

    private void enableUserImput() {
        this.getGlassPane().removeMouseListener(this.emptyMouseListener);
        this.getGlassPane().setVisible(false);
    }

    private void errorOccured(String errorMsg) {
        this.m_wiz.getCurrentPanel().setCancelButtonEnabled(true);
        this.enableUserImput();
        if (errorMsg != null) {
            SrOptionPaneUtil.showErrorMessage(this, errorMsg);
        }
    }

    @Override
    public void dispose() {
        runningWizards.remove(this.getClass());
        SrAction.updateAllActions();
        this.m_wiz.getCurrentPanel().removeListeners();
        ClusterManager.getInstance().removeClusterListener(this);
        CommunicationEventService.getInstance().removeCommunicationErrorListener(this);
        super.dispose();
    }

    public static boolean isAlreadyRunningWizard(Class wizClass) {
        return runningWizards.containsKey(wizClass);
    }

    public static void bringToFront(Class wizClass) {
        SrWizardFrame wiz = (SrWizardFrame)runningWizards.get(wizClass);
        if (wiz != null) {
            wiz.toFront();
        }
    }

    @Override
    public void configurationError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    @Override
    public void eventSynchronizationError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    @Override
    public void fatalConfigurationError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    @Override
    public void serverWasShutdown(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    @Override
    public void snmpError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    @Override
    public void clusterCreated(ClusterEvent event) {
    }

    @Override
    public void clusterPropertiesChanged(ClusterEvent event) {
    }

    @Override
    public void clusterRemoved(ClusterEvent event) {
        ClusterNode cluster = event.getClusterNode();
        if (this.m_involvedClusterList.contains(cluster)) {
            this.errorOccured(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_WIZ_CLUSTER_DELETED, cluster.getAlias()));
            this.dispose();
        }
    }

    @Override
    public void clusterStatusChanged(ClusterEvent event) {
    }

    @Override
    public void discoverCompleted(ClusterEvent event) {
    }

    @Override
    public void discoverStarted(ClusterEvent event) {
        ClusterNode cluster = event.getClusterNode();
        if (this.m_involvedClusterList.contains(cluster)) {
            this.errorOccured(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_WIZ_CLUSTER_REDISCOVERING, cluster.getAlias()));
            this.dispose();
        }
    }

    @Override
    public void refreshCluster(ClusterEvent event) {
    }

    @Override
    public void fail(String message) {
        this.setCursor(null);
        this.errorOccured(message);
    }

    @Override
    public final void inProcess(String message) {
        StatusPanel.getInstance().setText(message, StatusPanel.INFO, this);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public final void success(SrAction action) {
        this.setCursor(null);
    }

    @Override
    public final String getStatusStr() {
        return this.m_statusPanel.getStatusStr();
    }

    @Override
    public final void setStatusStr(String statusStr) {
        this.m_statusPanel.setStatusStr(statusStr);
    }

    @Override
    public void wizardTransactionsFinished() {
        this.enableUserImput();
    }

    @Override
    public void wizardTransactionsStarted() {
        this.disableUserInput();
    }
}

