/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.tree;

import com.sanrad.swing.tree.event.TreeNodeEvent;
import com.sanrad.swing.tree.event.TreeNodeListener;
import com.sanrad.util.SrEventListenerManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class SrRootTreeNode
extends DefaultMutableTreeNode {
    SrEventListenerManager m_listeners = new SrEventListenerManager();
    SrEventListenerManager.Informer treeNodeRemovingInformer = new SrEventListenerManager.Informer<TreeNodeListener, TreeNodeEvent>(){

        @Override
        public void inform(TreeNodeListener listener, TreeNodeEvent event) {
            listener.treeNodeRemoving(event);
        }
    };
    SrEventListenerManager.Informer treeNodeRemovedInformer = new SrEventListenerManager.Informer<TreeNodeListener, TreeNodeEvent>(){

        @Override
        public void inform(TreeNodeListener listener, TreeNodeEvent event) {
            listener.treeNodeRemoved(event);
        }
    };
    SrEventListenerManager.Informer treeNodeInsertedInformer = new SrEventListenerManager.Informer<TreeNodeListener, TreeNodeEvent>(){

        @Override
        public void inform(TreeNodeListener listener, TreeNodeEvent event) {
            listener.treeNodeInserted(event);
        }
    };

    public SrRootTreeNode() {
    }

    public SrRootTreeNode(Object userObject) {
        super(userObject);
    }

    @Override
    public void remove(int childIndex) {
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.getChildAt(childIndex);
        TreeNodeEvent e = new TreeNodeEvent(this, child, childIndex, 1);
        this.fireTreeNodeRemoving(e);
        super.remove(childIndex);
        this.fireTreeNodeRemoved(e);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        TreeNodeEvent e = new TreeNodeEvent(this, (DefaultMutableTreeNode)newChild, childIndex, 2);
        this.fireTreeNodeInserted(e);
    }

    public void addTreeNodeListener(TreeNodeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeTreeNodeListener(TreeNodeListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireTreeNodeRemoving(TreeNodeEvent event) {
        this.m_listeners.fireEvent(TreeNodeListener.class, event, this.treeNodeRemovingInformer);
    }

    private void fireTreeNodeRemoved(TreeNodeEvent event) {
        this.m_listeners.fireEvent(TreeNodeListener.class, event, this.treeNodeRemovedInformer);
    }

    private void fireTreeNodeInserted(TreeNodeEvent event) {
        this.m_listeners.fireEvent(TreeNodeListener.class, event, this.treeNodeInsertedInformer);
    }
}

