/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.toolbar;

import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class ToolbarButton
extends JButton {
    private RaisedBorder raisedBorder;
    private LoweredBorder loweredBorder;

    public ToolbarButton() {
        this("", null);
    }

    public ToolbarButton(String text) {
        this(text, null);
    }

    public ToolbarButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public ToolbarButton(Icon icon) {
        this(null, icon);
    }

    private void setButtonBorder(Border border) {
        this.setBorder(border);
    }

    protected void init() {
        this.raisedBorder = new RaisedBorder();
        this.loweredBorder = new LoweredBorder();
        this.setBackground(LookAndFill.TOOLBAR_BUTTON_BACKGROUND_COLOR);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.updateUI();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolbarButton.this.setBorderPainted(true);
                ToolbarButton.this.setButtonBorder(ToolbarButton.this.raisedBorder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolbarButton.this.setBorderPainted(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ToolbarButton.this.setBorderPainted(true);
                ToolbarButton.this.setButtonBorder(ToolbarButton.this.loweredBorder);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ToolbarButton.this.getBounds().contains(e.getPoint())) {
                    ToolbarButton.this.setBorderPainted(true);
                    ToolbarButton.this.setButtonBorder(ToolbarButton.this.raisedBorder);
                    return;
                }
                ToolbarButton.this.setBorderPainted(false);
            }
        });
    }

    class LoweredBorder
    extends BevelBorder {
        public LoweredBorder() {
            super(1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 6, 5, 6);
        }

        @Override
        protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(1, 1, 1, h - 2);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(2, h - 2, w - 2, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    class RaisedBorder
    extends BevelBorder {
        public RaisedBorder() {
            super(0);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 6, 5, 6);
        }

        @Override
        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(1, 0, w - 2, 0);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(1, 1, 1, h - 3);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(w - 1, 0, w - 1, h - 2);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

