/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class SrAbstractPlainDocument
extends PlainDocument {
    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.insert(offset, str);
        if (!this.isValidString(sb.toString())) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.insertString(offset, str, attr);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.delete(offs, offs + len);
        if (!this.isValidString(sb.toString())) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.replace(offset, offset + length, text);
        if (!this.isValidString(sb.toString())) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.replace(offset, length, text, attrs);
        }
    }

    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected abstract boolean isValidString(String var1);
}

