/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SignedIntegerDocument
extends PlainDocument {
    private int m_maxPositiveValue = Integer.MAX_VALUE;
    private int m_minNegativeValue = Integer.MIN_VALUE;
    private int m_maxLength = new Integer(Integer.MIN_VALUE).toString().length();

    public SignedIntegerDocument() {
    }

    public SignedIntegerDocument(int maxPositiveValue, int minNegativeValue) {
        if (maxPositiveValue < 0 || minNegativeValue > 0) {
            throw new IllegalArgumentException();
        }
        this.m_maxPositiveValue = maxPositiveValue;
        this.m_minNegativeValue = minNegativeValue;
        this.m_maxLength = Math.max(new Integer(maxPositiveValue).toString().length(), new Integer(minNegativeValue).toString().length());
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.insert(offset, str);
        if (!this.isValidString(sb)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.insertString(offset, str, attr);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.delete(offs, offs + len);
        if (!this.isValidString(sb)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.replace(offset, offset + length, text);
        if (!this.isValidString(sb)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.replace(offset, length, text, attrs);
        }
    }

    private boolean isValidString(StringBuffer sb) {
        if (sb.length() > 0) {
            if (this.m_maxLength < sb.length()) {
                return false;
            }
            boolean isNegative = false;
            if (sb.charAt(0) == '-') {
                isNegative = true;
                sb.deleteCharAt(0);
            }
            if (sb.length() > 0) {
                int i = sb.length();
                while (i-- > 0) {
                    if (Character.isDigit(sb.charAt(i))) continue;
                    return false;
                }
                if (isNegative && sb.charAt(0) == '0' || sb.charAt(0) == '0' && sb.length() > 1) {
                    return false;
                }
                long value = Long.parseLong(sb.toString());
                if (!isNegative && value > (long)this.m_maxPositiveValue || isNegative && -1L * value < (long)this.m_minNegativeValue) {
                    return false;
                }
            }
        }
        return true;
    }
}

