/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class LimitedLinesDocument
extends DefaultStyledDocument {
    private static final int CHARS_IN_LINE = 45;

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str != null && str.length() <= 45) {
            super.insertString(offset, str, attr);
        } else if (str != null && str.length() > 45) {
            super.insertString(offset, this.getParsedString(str), attr);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private String getParsedString(String str) {
        String s = "";
        int index = 0;
        int padd = 0;
        while (index <= str.length()) {
            if (index + 45 < str.length()) {
                s = s + str.substring(index, index + 45);
                padd = this.findNextSpace(str, index + 45) + 1;
                if (padd > 1) {
                    s = s + str.substring(index + 45, padd);
                }
            } else {
                s = s + str.substring(index, str.length());
                break;
            }
            s = s + "\n";
            if (padd > 0) {
                index = padd;
                continue;
            }
            index += 45;
        }
        return s;
    }

    private int findNextSpace(String string, int startInd) {
        int res = string.indexOf(" ", startInd);
        if (res == -1) {
            res = string.length() - 1;
        }
        return res;
    }
}

