/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class IntegerDocument
extends LengthLimitedDocument {
    private int maxValue = Integer.MAX_VALUE;
    private int minValue = Integer.MIN_VALUE;

    public IntegerDocument() {
        this(-1);
    }

    public IntegerDocument(int length) {
        super(length);
    }

    public IntegerDocument(int length, int maxValue) {
        this(length);
        this.maxValue = maxValue;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str != null) {
            try {
                String currentValue = this.getText(0, this.getLength());
                if (!this.isValid(currentValue, Integer.parseInt(str), offset)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offset, str, attr);
        }
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    protected boolean isValid(String currentValue, int addedValue, int offset) {
        String leftValue = currentValue.substring(0, offset);
        String rightValue = currentValue.substring(offset, currentValue.length());
        String newStrValue = leftValue + addedValue + rightValue;
        if (offset == 1 && leftValue.equals("0") && addedValue == 0) {
            return false;
        }
        int newIntValue = Integer.parseInt(newStrValue);
        return newIntValue >= this.minValue && newIntValue <= this.maxValue;
    }
}

