/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class DecimalDocument
extends LengthLimitedDocument {
    float myMaxValue = Float.MAX_VALUE;
    float myMinValue = Float.MIN_VALUE;

    public DecimalDocument() {
        this(-1);
    }

    public DecimalDocument(int length) {
        super(length);
    }

    public DecimalDocument(int length, int maxValue) {
        this(length);
        this.myMaxValue = maxValue;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str != null) {
            try {
                String currentValue = this.getText(0, this.getLength());
                if (str.equals(".") && currentValue.indexOf(".") > -1) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (!str.equals(".") && !this.isValid(currentValue, Integer.parseInt(str), offset)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offset, str, attr);
        }
    }

    protected boolean isValid(String currentValue, int addedValue, int offset) {
        String leftValue = currentValue.substring(0, offset);
        String rightValue = currentValue.substring(offset, currentValue.length());
        String newStrValue = leftValue + addedValue + rightValue;
        if (offset == 1 && leftValue.equals("0") && addedValue == 0) {
            return false;
        }
        float newDecimalValue = Float.parseFloat(newStrValue);
        return newDecimalValue >= this.myMinValue && newDecimalValue <= this.myMaxValue;
    }
}

