/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class AliasDocument
extends LengthLimitedDocument {
    private static final int DEFAULT_MAX_LENGTH_LIMIT = 256;
    private String myRegExAllowedCharacers = null;

    public AliasDocument(int aLimit, String aForbiddenCharsRegEX) {
        super(aLimit);
        this.myRegExAllowedCharacers = aForbiddenCharsRegEX;
    }

    public AliasDocument(String aForbiddenCharsRegEX) {
        this(256, aForbiddenCharsRegEX);
    }

    public AliasDocument() {
        this((String)null);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (!this.isValidForTargetAlias(str)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offset, str, attr);
    }

    private boolean isValidForTargetAlias(String aStr) {
        if (this.myRegExAllowedCharacers == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(this.myRegExAllowedCharacers);
        Matcher matcher = pattern.matcher(aStr);
        return matcher.find();
    }
}

