/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.table;

import com.sanrad.swing.table.ColumnGroup;
import com.sanrad.swing.table.GroupableTableHeaderUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GroupableTableHeader
extends JTableHeader {
    protected Vector columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setReorderingAllowed(false);
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public ColumnGroup getGroupByName(String groupName) {
        ColumnGroup returnGroup = null;
        for (int i = 0; i < this.columnGroups.size(); ++i) {
            ColumnGroup g = (ColumnGroup)this.columnGroups.get(i);
            if (!g.getHeaderValue().equals(groupName)) continue;
            returnGroup = g;
            break;
        }
        return returnGroup;
    }

    public List getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        for (ColumnGroup cGroup : this.columnGroups) {
            List v_ret = cGroup.getColumnGroups(col, new ArrayList());
            if (v_ret == null) continue;
            return v_ret;
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin() - 1;
        for (ColumnGroup cGroup : this.columnGroups) {
            cGroup.setColumnMargin(columnMargin);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new GroupableTableHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }
}

