/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.table;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.border.SrLineBorder;
import com.sanrad.util.SrResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector v;
    protected String text;
    protected int margin = 0;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this.renderer = renderer == null ? new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBackground(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.TABLE_HEADER_BACKGROUND_COLOR));
                Color borderColor = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.TABLE_HEADER_BORDER_COLOR);
                SrLineBorder lineBorder = new SrLineBorder(0, 0, 1, 1, borderColor);
                Border emptyBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
                this.setBorder(BorderFactory.createCompoundBorder(lineBorder, emptyBorder));
                return this;
            }
        } : renderer;
        this.text = text;
        this.v = new Vector();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.v.addElement(obj);
    }

    public Vector getGroupTableColumns() {
        return this.v;
    }

    public List getColumnGroups(TableColumn c, List g) {
        g.add(this);
        if (this.v.contains(c)) {
            return g;
        }
        for (Object obj : this.v) {
            List groups;
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c, new ArrayList(g))) == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public void setHeaderValue(String text) {
        this.text = text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        for (Object obj : this.v) {
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                width += this.margin;
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        for (Object obj : this.v) {
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }
}

