/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.spinner;

import com.sanrad.swing.spinner.SrListSpinnerModel;
import com.sanrad.util.Util;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class SrSpinner
extends JSpinner {
    private static final long serialVersionUID = 1L;

    public SrSpinner() {
        this.init();
    }

    public SrSpinner(SpinnerModel aModel) {
        super(aModel);
        this.init();
    }

    public SrSpinner(SrListSpinnerModel aModel) {
        super(aModel);
        this.init();
        SpinnerValueParser parser = aModel.getSpinnerValueParser();
        if (parser != null) {
            DefaultFormatterFactory factory = new DefaultFormatterFactory();
            factory.setDefaultFormatter(new SrSpinnerListFormatter(parser));
            this.getTextField().setDocument(aModel.getDocument());
            this.getTextField().setFormatterFactory(factory);
        }
    }

    private void init() {
        this.getTextField().addComponentListener(new ComponentAdapter(){
            private boolean myIsResized = false;

            @Override
            public void componentResized(ComponentEvent e) {
                JFormattedTextField textField = SrSpinner.this.getTextField();
                Dimension textFieldSize = textField.getSize();
                if (!this.myIsResized && textFieldSize.width != 0 && textFieldSize.height != 0) {
                    textField.setPreferredSize(textFieldSize);
                    SrSpinner.this.getTextField().removeComponentListener(this);
                    this.myIsResized = true;
                }
            }
        });
    }

    public JFormattedTextField getTextField() {
        return ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
    }

    public Object getValueFromInput() {
        JFormattedTextField tf = this.getTextField();
        try {
            String text = tf.getText();
            if (text.isEmpty()) {
                return this.getValue();
            }
            return tf.getFormatter().stringToValue(tf.getText());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setEditable(boolean aEditable) {
        this.getTextField().setEditable(aEditable);
    }

    private static class SrSpinnerListFormatter
    extends DefaultFormatter {
        private static final long serialVersionUID = 1L;
        private SpinnerValueParser myParser;

        SrSpinnerListFormatter(SpinnerValueParser aParser) {
            Util.validateInputNotNull(aParser, "SpinnerValueParser");
            this.myParser = aParser;
        }

        @Override
        public Object stringToValue(String aText) {
            return this.myParser.stringToValue(aText);
        }
    }

    public static interface SpinnerValueParser {
        public Object stringToValue(String var1);
    }
}

