/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.spinner;

import com.sanrad.swing.spinner.SrSpinner;
import com.sanrad.swing.text.SrAbstractPlainDocument;
import com.sanrad.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractSpinnerModel;
import javax.swing.text.Document;

public abstract class SrListSpinnerModel
extends AbstractSpinnerModel {
    private ArrayList myValues = new ArrayList();
    private int mySelectedIndex = 0;
    private SrAbstractPlainDocument myDocument = new SrAbstractPlainDocument(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean isValidString(String aText) {
            return SrListSpinnerModel.this.isValidText(aText);
        }
    };

    public SrListSpinnerModel(List aValues) {
        this(aValues, null);
    }

    public SrListSpinnerModel(List aValues, Object aDefaultValue) {
        Util.validateInputNotNull(aValues, "Spinner Values");
        this.setModelValues(aValues, aDefaultValue);
    }

    public void setModelValues(List aValues, Object aDefaultValue) {
        this.myValues.addAll(aValues);
        this.mySelectedIndex = Math.max(this.myValues.indexOf(aDefaultValue), 0);
        this.fireStateChanged();
    }

    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    public Object getNextValue() {
        this.changeSelectedIndexByText();
        return this.mySelectedIndex == 0 ? null : this.myValues.get(this.mySelectedIndex - 1);
    }

    @Override
    public Object getPreviousValue() {
        this.changeSelectedIndexByText();
        return this.mySelectedIndex == this.myValues.size() - 1 ? null : this.myValues.get(this.mySelectedIndex + 1);
    }

    @Override
    public Object getValue() {
        return this.myValues.get(this.mySelectedIndex);
    }

    @Override
    public void setValue(Object value) {
        this.mySelectedIndex = this.myValues.indexOf(value);
        if (this.mySelectedIndex < 0) {
            this.mySelectedIndex = 0;
            return;
        }
        this.fireStateChanged();
    }

    private void changeSelectedIndexByText() {
        Object value;
        SrSpinner.SpinnerValueParser parser = this.getSpinnerValueParser();
        if (parser != null && (value = parser.stringToValue(this.myDocument.getText())) != null) {
            this.mySelectedIndex = this.myValues.indexOf(value);
        }
    }

    abstract SrSpinner.SpinnerValueParser getSpinnerValueParser();

    abstract boolean isValidText(String var1);
}

