/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.spinner;

import com.sanrad.swing.spinner.SrListSpinnerModel;
import com.sanrad.swing.spinner.SrSpinner;
import com.sanrad.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class PercentageSpinnerModel
extends SrListSpinnerModel {
    private static Pattern thePercentagePatern = Pattern.compile("\\d{0,3}%$");
    private static final char PRECENTAGE_POSTFIX = '%';
    private SrSpinner.SpinnerValueParser myParser = new SrSpinner.SpinnerValueParser(){

        @Override
        public Object stringToValue(String aText) {
            int inputValue;
            String valueStr = aText;
            if (!aText.isEmpty() && aText.charAt(aText.length() - 1) == '%') {
                valueStr = aText.substring(0, aText.length() - 1);
            }
            if (Util.isUnsignedInt(valueStr) && (inputValue = Integer.parseInt(valueStr)) >= PercentageSpinnerModel.this.myMinValue && inputValue <= PercentageSpinnerModel.this.myMaxValue) {
                return new PercentageValue(inputValue);
            }
            return null;
        }
    };
    private int myMinValue;
    private int myMaxValue;

    public PercentageSpinnerModel(int aMinValue, int aMaxValue, int aDefaultValue) {
        super(PercentageSpinnerModel.createValuesList(aMinValue, aMaxValue));
        if (aDefaultValue > aMaxValue || aDefaultValue < aMinValue) {
            throw new IllegalArgumentException("Default value " + aDefaultValue + " is not valid, sould be between " + aMinValue + " to " + aMaxValue);
        }
        this.myMinValue = aMinValue;
        this.myMaxValue = aMaxValue;
        this.setValue(new PercentageValue(aDefaultValue));
    }

    private static List<PercentageValue> createValuesList(int aMinValue, int aMaxValue) {
        if (aMinValue > aMaxValue) {
            throw new IllegalArgumentException("Minimum value " + aMinValue + " is larger then the maximum value " + aMaxValue);
        }
        ArrayList<PercentageValue> values = new ArrayList<PercentageValue>();
        for (int i = aMaxValue; i >= aMinValue; --i) {
            PercentageValue value = new PercentageValue(i);
            values.add(value);
        }
        return values;
    }

    @Override
    protected boolean isValidText(String aText) {
        if (aText.isEmpty() || aText.length() == 1 && aText.charAt(0) == '%') {
            return true;
        }
        if (thePercentagePatern.matcher(aText).matches()) {
            String intStr = aText.substring(0, aText.length() - 1);
            int value = Integer.parseInt(intStr);
            return value <= this.myMaxValue;
        }
        if (Util.isUnsignedInt(aText)) {
            int value = Integer.parseInt(aText);
            return value <= this.myMaxValue;
        }
        return false;
    }

    @Override
    SrSpinner.SpinnerValueParser getSpinnerValueParser() {
        return this.myParser;
    }

    public static class PercentageValue {
        int myValue;
        String myStrValue;

        public PercentageValue(int aValue) {
            if (aValue < 0) {
                throw new IllegalArgumentException("Illegal percentage value " + aValue);
            }
            this.myValue = aValue;
            StringBuilder sb = new StringBuilder();
            sb.append(aValue).append('%');
            this.myStrValue = sb.toString();
        }

        public String toString() {
            return this.myStrValue;
        }

        public int getValue() {
            return this.myValue;
        }

        public boolean equals(Object o) {
            String otherString;
            if (o instanceof String && Util.isUnsignedInt(otherString = (String)o)) {
                int otherValue = Integer.parseInt(otherString);
                return otherValue == this.myValue;
            }
            return this.toString().equals(o.toString());
        }
    }
}

