/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.jwf;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collections;
import javax.swing.SwingUtilities;

public abstract class WizardTransaction
implements Runnable {
    private static SrLogger theLogger = SrLogger.getLogger();
    Object m_synchronizeLock = new Object();
    Thread m_invokingThread;
    private boolean m_needSynchronization = true;
    private boolean myIsSuccess = true;

    protected abstract void transaction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.m_invokingThread = Thread.currentThread();
        this.transaction();
        if (this.m_needSynchronization) {
            Object object = this.m_synchronizeLock;
            synchronized (object) {
                try {
                    this.m_synchronizeLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (this.m_invokingThread != Thread.currentThread()) {
            Object object = this.m_synchronizeLock;
            synchronized (object) {
                this.m_synchronizeLock.notifyAll();
            }
        } else {
            this.m_needSynchronization = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitAndBlockActions(SrFuture<Void> aActFuture, OperationController aOwner) {
        theLogger.logAndAssert(SrLogCategories.ERROR, !SwingUtilities.isEventDispatchThread(), new Object[]{"This method should not be performed by the Event Dispather Thread"});
        SrAction.blockActions(Collections.singleton(aActFuture), aOwner);
        try {
            aActFuture.get();
            this.myIsSuccess = true;
        }
        catch (SrExecutionException e) {
            this.myIsSuccess = false;
        }
        catch (InterruptedException e) {
            this.myIsSuccess = false;
        }
        finally {
            this.stop();
        }
    }

    boolean isSuccess() {
        return this.myIsSuccess;
    }
}

