/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.jwf;

import com.sanrad.swing.SrPanel;
import com.sanrad.swing.jwf.WizardButtonsEvent;
import com.sanrad.swing.jwf.WizardButtonsListener;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.ContextKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;

public abstract class WizardPanel
extends SrPanel {
    private WizardButtonsListener m_wizardButtonsListener;
    private boolean m_savePrev = true;
    private WizardPanel m_goBackToThisPanel = null;
    private ArrayList m_wizardTransactionsList = new ArrayList();
    private boolean m_isDisplayable = true;
    private Summary m_summary;
    private static final HashMap NEXT_FALSE_MAP = new HashMap(1);
    private static final HashMap NEXT_TRUE_MAP = new HashMap(1);
    private static final HashMap BACK_FALSE_MAP = new HashMap(1);
    private static final HashMap BACK_TRUE_MAP = new HashMap(1);
    private static final HashMap APPLY_FALSE_MAP = new HashMap(1);
    private static final HashMap APPLY_TRUE_MAP = new HashMap(1);
    private static final HashMap CANCEL_FALSE_MAP = new HashMap(1);
    private static final HashMap CANCEL_TRUE_MAP = new HashMap(1);
    protected WizardContext wizardContext;

    public WizardPanel() {
        this.setOpaque(false);
    }

    public final void setWizardContext(WizardContext wizardContext) {
        this.wizardContext = wizardContext;
    }

    public abstract void display();

    public abstract boolean hasNext();

    public abstract boolean validateNext(List var1);

    public abstract String getConfirmMessage();

    public abstract WizardPanel next();

    public Action getNextButtonAction() {
        return null;
    }

    public Action getFinishButtonAction() {
        return null;
    }

    public abstract void back();

    public abstract boolean canFinish();

    public abstract boolean validateFinish(List var1);

    public abstract void finish();

    public void apply() {
    }

    public boolean hasHelp() {
        return false;
    }

    public void help() {
    }

    public final WizardContext getWizardContext() {
        return this.wizardContext;
    }

    public final void setWizardButtonsListener(WizardButtonsListener l) {
        this.m_wizardButtonsListener = l;
    }

    protected final void fireNextButtonAction() {
        this.fireButtonActionPerformed(new WizardButtonsEvent(this, "NEXT_I18N"));
    }

    public final void setNextButtonEnabled(boolean enable) {
        if (enable) {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, NEXT_TRUE_MAP));
        } else {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, NEXT_FALSE_MAP));
        }
    }

    public final void setBackButtonEnabled(boolean enable) {
        if (enable) {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, BACK_TRUE_MAP));
        } else {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, BACK_FALSE_MAP));
        }
    }

    public final void setApplyButtonEnabled(boolean enable) {
        if (enable) {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, APPLY_TRUE_MAP));
        } else {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, APPLY_FALSE_MAP));
        }
    }

    public final void setCancelButtonEnabled(boolean enable) {
        if (enable) {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, CANCEL_TRUE_MAP));
        } else {
            this.fireButtonEnableStateChanged(new WizardButtonsEvent(this, CANCEL_FALSE_MAP));
        }
    }

    protected final void setButtonVisible(String actionCommand, boolean visible) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put(actionCommand, visible ? Boolean.TRUE : Boolean.FALSE);
        this.fireButtonVisibilityChanged(new WizardButtonsEvent(this, map));
    }

    protected final void setButtonText(String actionCommand, String newText) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(actionCommand, newText);
        this.fireButtonTextChanged(new WizardButtonsEvent(this, map));
    }

    private void fireButtonEnableStateChanged(WizardButtonsEvent event) {
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.buttonsEnableStateChanged(event);
        }
    }

    private void fireButtonVisibilityChanged(WizardButtonsEvent event) {
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.buttonsVisibilityChanged(event);
        }
    }

    private void fireButtonTextChanged(WizardButtonsEvent event) {
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.buttonsTextChanged(event);
        }
    }

    private void fireButtonActionPerformed(WizardButtonsEvent event) {
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.buttonPerformAction(event);
        }
    }

    protected final void invokeButtonVisiblityChangeLater(String actionCommand, boolean visible) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put(actionCommand, visible ? Boolean.TRUE : Boolean.FALSE);
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.invokeVisibilityChangeLater(new WizardButtonsEvent(this, map));
        }
    }

    protected final void invokeButtonEnableStateChangeLater(String actionCommand, boolean enabled) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put(actionCommand, enabled ? Boolean.TRUE : Boolean.FALSE);
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.invokeEnableStateChangeLater(new WizardButtonsEvent(this, map));
        }
    }

    protected final void invokeButtonTextChangeLater(String actionCommand, String newText) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(actionCommand, newText);
        if (this.m_wizardButtonsListener != null) {
            this.m_wizardButtonsListener.invokeTextChangeLater(new WizardButtonsEvent(this, map));
        }
    }

    public final boolean isSavedAsPervious() {
        return this.m_savePrev;
    }

    public void setSavedAsPrevious(boolean save) {
        this.m_savePrev = save;
    }

    public final WizardPanel getBackPanel() {
        return this.m_goBackToThisPanel;
    }

    public final void setBackPanel(WizardPanel panel) {
        this.m_goBackToThisPanel = panel;
    }

    final void initSummary(WizardPanel prev) {
        this.m_summary = new Summary(prev);
    }

    final void updateSummary() {
        this.m_summary.update();
    }

    final WizardContext.Entry[] getSummary() {
        return this.m_summary.getAll();
    }

    protected final void clearSummary() {
        this.m_summary.summaryEntryList.clear();
    }

    protected void addWizardTransaction(WizardTransaction transaction) {
        if (!this.m_wizardTransactionsList.contains(transaction)) {
            this.m_wizardTransactionsList.add(transaction);
        }
    }

    protected final boolean removeWizardTransaction(WizardTransaction transaction) {
        return this.m_wizardTransactionsList.remove(transaction);
    }

    public final WizardTransaction[] getWizardTransactions() {
        WizardTransaction[] list = new WizardTransaction[this.m_wizardTransactionsList.size()];
        return this.m_wizardTransactionsList.toArray(list);
    }

    @Override
    public final boolean isDisplayable() {
        return this.m_isDisplayable;
    }

    protected final void setDisplayable(boolean isDisplayable) {
        this.m_isDisplayable = isDisplayable;
    }

    @Override
    public abstract void removeListeners();

    public abstract String getDescription();

    public abstract void exit();

    static {
        NEXT_FALSE_MAP.put("NEXT_I18N", Boolean.FALSE);
        NEXT_TRUE_MAP.put("NEXT_I18N", Boolean.TRUE);
        BACK_FALSE_MAP.put("BACK_I18N", Boolean.FALSE);
        BACK_TRUE_MAP.put("BACK_I18N", Boolean.TRUE);
        APPLY_FALSE_MAP.put("APPLY_I18N", Boolean.FALSE);
        APPLY_TRUE_MAP.put("APPLY_I18N", Boolean.TRUE);
        CANCEL_FALSE_MAP.put("CANCEL_I18N", Boolean.FALSE);
        CANCEL_TRUE_MAP.put("CANCEL_I18N", Boolean.TRUE);
    }

    private static class SummaryEntry {
        WizardPanel m_panel;
        ArrayList wizContxtEntries = new ArrayList();

        SummaryEntry(WizardPanel panel) {
            this.m_panel = panel;
            ArrayList attributes = panel.wizardContext.getListOfAttributeKeysForObject(panel);
            if (attributes != null) {
                int i = attributes.size();
                while (i-- > 0) {
                    Object value;
                    ContextKey ctxKey;
                    Object key = attributes.get(i);
                    if (key instanceof ContextKey && !(ctxKey = (ContextKey)key).isDisplayable() || (value = panel.wizardContext.getAttribute(key)) == null) continue;
                    this.wizContxtEntries.add(new WizardContext.Entry(key, value));
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof WizardPanel) {
                return o == this.m_panel;
            }
            if (o instanceof SummaryEntry) {
                return ((SummaryEntry)o).m_panel == this.m_panel;
            }
            return false;
        }
    }

    private class Summary {
        ArrayList summaryEntryList;

        Summary(WizardPanel prev) {
            if (prev != null) {
                this.summaryEntryList = new ArrayList(((WizardPanel)prev).m_summary.summaryEntryList);
                this.removeSummaryEntry(prev);
                this.summaryEntryList.add(new SummaryEntry(prev));
            } else {
                this.summaryEntryList = new ArrayList();
            }
        }

        void update() {
            this.removeSummaryEntry(WizardPanel.this);
            this.summaryEntryList.add(new SummaryEntry(WizardPanel.this));
        }

        void removeSummaryEntry(WizardPanel panel) {
            int i = this.summaryEntryList.size();
            while (i-- > 0) {
                if (((SummaryEntry)this.summaryEntryList.get((int)i)).m_panel != panel) continue;
                this.summaryEntryList.remove(i);
                break;
            }
        }

        WizardContext.Entry[] getAll() {
            ArrayList list = new ArrayList();
            for (SummaryEntry sumEntry : this.summaryEntryList) {
                list.addAll(sumEntry.wizContxtEntries);
            }
            return list.toArray(new WizardContext.Entry[list.size()]);
        }
    }
}

