/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.jwf;

import com.sanrad.swing.jwf.WizardPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WizardContext {
    private final HashMap m_classToWizardPanels = new HashMap();
    private final HashMap attributes = new HashMap();
    private final HashMap m_panelToAttributeList = new HashMap();

    public void setAttribute(Object key, Object value, WizardPanel panel) {
        this.attributes.put(key, value);
        if (panel != null) {
            ArrayList<Object> list = (ArrayList<Object>)this.m_panelToAttributeList.get(panel);
            if (list == null) {
                list = new ArrayList<Object>();
                this.m_panelToAttributeList.put(panel, list);
            }
            if (!list.contains(key)) {
                list.add(key);
            }
            if (value == null) {
                list.remove(key);
            }
        }
    }

    public <T> T getAttribute(Object key) {
        return (T)this.attributes.get(key);
    }

    public ArrayList getListOfAttributeKeysForObject(WizardPanel panel) {
        return (ArrayList)this.m_panelToAttributeList.get(panel);
    }

    public List getAllValues() {
        return new ArrayList(this.attributes.values());
    }

    public void clearAttributes() {
        this.attributes.clear();
        this.m_panelToAttributeList.clear();
        this.m_classToWizardPanels.clear();
    }

    void addWizardPanel(WizardPanel panel) {
        Class<?> key = panel.getClass();
        ArrayList<WizardPanel> panelList = (ArrayList<WizardPanel>)this.m_classToWizardPanels.get(key);
        if (panelList == null) {
            panelList = new ArrayList<WizardPanel>();
            this.m_classToWizardPanels.put(key, panelList);
        }
        if (!panelList.contains(panel)) {
            panelList.add(panel);
        }
    }

    public WizardPanel getWizardPanel(Class key) {
        return this.getWizardPanel(key, 0);
    }

    public WizardPanel getWizardPanel(Class key, int instance) {
        return (WizardPanel)((ArrayList)this.m_classToWizardPanels.get(key)).get(instance);
    }

    void removeWizardPanel(WizardPanel panel) {
        Class<?> key = panel.getClass();
        ArrayList panelList = (ArrayList)this.m_classToWizardPanels.get(key);
        if (panelList != null) {
            panelList.remove(panel);
            if (panelList.isEmpty()) {
                this.m_classToWizardPanels.remove(key);
            }
        }
    }

    public static class Entry {
        private Object key;
        private Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

