/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.jwf;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrComponentNameBundleKeys;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.swing.jwf.ErrorMessageBox;
import com.sanrad.swing.jwf.NullWizardPanel;
import com.sanrad.swing.jwf.WizardButtonsEvent;
import com.sanrad.swing.jwf.WizardButtonsListener;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardListener;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.jwf.WizardTransactionMonitor;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Wizard
extends SrPanel
implements WizardButtonsListener {
    public static final String BACK_I18N = "BACK_I18N";
    public static final String NEXT_I18N = "NEXT_I18N";
    public static final String FINISH_I18N = "FINISH_I18N";
    public static final String CANCEL_I18N = "CANCEL_I18N";
    public static final String HELP_I18N = "HELP_I18N";
    public static final String APPLY_I18N = "APPLY_I18N";
    private static final int WIZARD_PREFERRED_WIDTH = 490;
    private static final int WIZARD_PREFERRED_HEIGHT = 470;
    public static final String BACK = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_BACK_BUTTON);
    public static final String NEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_NEXT_BUTTON);
    public static final String FINISH = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_FINISH_BUTTON);
    public static final String CANCEL = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_CANCEL_BUTTON);
    public static final String HELP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_HELP_BUTTON);
    public static final String NO = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_NO_BUTTON);
    public static final String YES = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_YES_BUTTON);
    public static final String OK = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_OK_BUTTON);
    public static final String APPLY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WIZARD_APPLY_BUTTON);
    private final JButton backButton = new JButton(BACK);
    private final JButton nextButton = new JButton(NEXT);
    private final JButton applyButton = new JButton(APPLY);
    private final JButton finishButton = new JButton(FINISH);
    private final JButton cancelButton = new JButton(CANCEL);
    private final JButton helpButton = new JButton(HELP);
    private ArrayList m_pendingVisibilityEvents = new ArrayList();
    private ArrayList m_pendingEnableStateEvents = new ArrayList();
    private ArrayList m_pendingTextChangeEvents = new ArrayList();
    private SrEventListenerManager m_listeners = new SrEventListenerManager();
    private Stack<WizardPanel> previous = null;
    private WizardPanel current = null;
    private WizardContext ctx = null;
    private Map i18n = null;
    private WizardTransactionMonitor m_transactionMonitor = null;
    private SrComponentStatusBarPanel m_statusPanel;
    private SrMultiLineLabel m_wizDescLabel;
    private SrPanel m_mainPanel;
    private SrPanel m_descPanel;
    private ImageIcon myImage;
    SrEventListenerManager.Informer<WizardListener, EventObject> wizardPanelChangedInformer = new SrEventListenerManager.Informer<WizardListener, EventObject>(){

        @Override
        public void inform(WizardListener listener, EventObject event) {
            listener.wizardPanelChanged(event);
        }
    };
    SrEventListenerManager.Informer<WizardListener, EventObject> wizardFinishedInformer = new SrEventListenerManager.Informer<WizardListener, EventObject>(){

        @Override
        public void inform(WizardListener listener, EventObject event) {
            listener.wizardFinished(event);
        }
    };
    SrEventListenerManager.Informer<WizardListener, EventObject> wizardCancelledInformer = new SrEventListenerManager.Informer<WizardListener, EventObject>(){

        @Override
        public void inform(WizardListener listener, EventObject event) {
            listener.wizardCancelled(event);
        }
    };
    private SrTableModel m_tableSummaryModel = new SrTableModel(new SummaryTableColumns()){

        @Override
        public void removeListeners() {
        }

        @Override
        public void addListeners() {
        }
    };
    private SrTablePanel m_summaryListPanel = new SrTablePanel(this.m_tableSummaryModel);
    private WizardFocusManager m_focusManager = new WizardFocusManager();

    public Wizard(ImageIcon aWizardImage) {
        this.myImage = aWizardImage;
        this.init();
    }

    private void displaySummaryText(WizardPanel wp) {
        this.m_tableSummaryModel.removeAllRows();
        WizardContext.Entry[] summary = wp.getSummary();
        for (int i = 0; i < summary.length; ++i) {
            this.m_tableSummaryModel.addRow(new Object[]{summary[i].getKey(), summary[i].getValue()});
        }
    }

    private void init() {
        this.m_summaryListPanel.getTable().setName(ClientLoader.COMP_NAMES_BUNDLE.getString(SrComponentNameBundleKeys.TABLE_DR_WIZARD_SUMMARY));
        this.setBackground(LookAndFill.DIALOG_COLOR);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wizard.this.m_transactionMonitor.wizardTransactionsStarted();
                Wizard.this.removeMnemonics();
                String wizardPanelName = Wizard.this.current != null ? Wizard.this.current.getClass().getSimpleName() : "\"Next\"";
                Thread t = new Thread("Wizard " + wizardPanelName + " Transaction"){

                    @Override
                    public void run() {
                        Wizard.this.next();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Wizard.this.m_transactionMonitor.wizardTransactionsFinished();
                                Wizard.this.updateMnemonics();
                            }
                        });
                    }
                };
                t.start();
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wizard.this.apply();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wizard.this.back();
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Thread t = new Thread("Wizard \"Next\" Transaction"){

                    @Override
                    public void run() {
                        Wizard.this.finish();
                    }
                };
                t.start();
            }
        });
        ActionListener cancelAct = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wizard.this.cancel();
            }
        };
        this.cancelButton.addActionListener(cancelAct);
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wizard.this.help();
            }
        });
        this.nextButton.setMnemonic(78);
        this.applyButton.setMnemonic(65);
        this.backButton.setMnemonic(66);
        this.finishButton.setMnemonic(70);
        this.cancelButton.setMnemonic(67);
        this.helpButton.setMnemonic(72);
        this.nextButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.helpButton.setEnabled(false);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.cancelButton.registerKeyboardAction(cancelAct, escape, 2);
        this.setLayout(new BorderLayout());
        SrPanel navButtons = new SrPanel();
        navButtons.setLayout(new FlowLayout(2, 5, 10));
        SrPanel tmpNavButtons = new SrPanel(new FlowLayout(2, 0, 0));
        tmpNavButtons.add(this.backButton);
        tmpNavButtons.add(this.nextButton);
        tmpNavButtons.add(this.applyButton);
        navButtons.add(tmpNavButtons);
        navButtons.add(this.finishButton);
        navButtons.add(this.cancelButton);
        SrPanel cancelButtons = new SrPanel();
        cancelButtons.setLayout(new FlowLayout(0, 5, 10));
        cancelButtons.add(this.helpButton);
        SrPanel buttonsAndStatus = new SrPanel(new BorderLayout());
        SrPanel buttonsPanel = new SrPanel(new BorderLayout());
        buttonsPanel.add((Component)navButtons, "East");
        buttonsPanel.add((Component)cancelButtons, "West");
        buttonsAndStatus.add((Component)buttonsPanel, "Center");
        this.m_statusPanel = new SrComponentStatusBarPanel();
        buttonsAndStatus.add((Component)this.m_statusPanel, "South");
        this.m_mainPanel = new SrPanel(new BorderLayout());
        this.m_mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_descPanel = new SrPanel(new BorderLayout());
        this.m_descPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_wizDescLabel = new SrMultiLineLabel();
        this.m_wizDescLabel.setForeground(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.WIZARD_DESCRIPTION_COLOR));
        this.m_wizDescLabel.setFont(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getFontResource(SrDefaultUIBundleKeys.WIZARD_DESCRIPTION_FONT));
        Dimension wizPreferredSize = new Dimension(490, 470);
        this.setMinimumSize(wizPreferredSize);
        this.setPreferredSize(wizPreferredSize);
        this.add((Component)buttonsAndStatus, "South");
        this.add((Component)this.m_mainPanel, "Center");
        if (this.myImage != null) {
            wizPreferredSize.width += this.myImage.getIconWidth();
            wizPreferredSize.height = Math.max(this.myImage.getIconHeight(), 470);
            this.add((Component)new JLabel(this.myImage), "West");
        }
    }

    private void displayDescription() {
        String desc = this.current.getDescription();
        this.m_mainPanel.remove(this.m_descPanel);
        if (desc != null) {
            this.m_wizDescLabel.setText(desc);
            this.m_descPanel.add(this.m_wizDescLabel);
            this.m_mainPanel.add((Component)this.m_descPanel, "North");
        }
    }

    public int getSummaryListPanelWidth() {
        return this.m_summaryListPanel.getSize().width;
    }

    public void setI18NMap(Map map) {
        this.i18n = map;
        this.applyI18N(this.i18n);
    }

    private void applyI18N(Map map) {
        if (map.size() > 0) {
            this.nextButton.setText((String)map.get(NEXT_I18N));
            this.applyButton.setText((String)map.get(APPLY_I18N));
            this.backButton.setText((String)map.get(BACK_I18N));
            this.finishButton.setText((String)map.get(FINISH_I18N));
            this.cancelButton.setText((String)map.get(CANCEL_I18N));
            this.helpButton.setText((String)map.get(HELP_I18N));
            this.backButton.setActionCommand("< Back");
            this.nextButton.setActionCommand("Next >");
            this.applyButton.setActionCommand("Apply");
            this.finishButton.setActionCommand("Finish");
            this.cancelButton.setActionCommand("Cancel");
            this.helpButton.setActionCommand("Help");
        }
    }

    public void addWizardListener(WizardListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeWizardListener(WizardListener listener) {
        this.m_listeners.remove(listener);
    }

    public void start(WizardPanel wp, SrWizardFrame frm) {
        this.previous = new Stack();
        this.ctx = new WizardContext();
        this.ctx.setAttribute(SrWizardFrame.OWNER_KEY, frm, null);
        wp.setWizardContext(this.ctx);
        wp.setWizardButtonsListener(this);
        wp.initSummary(null);
        if (wp.isDisplayable()) {
            this.setPanel(wp);
            wp.updateSummary();
            this.displaySummaryText(wp);
        } else {
            this.current = wp;
            this.next();
        }
    }

    private void setPanel(WizardPanel wp) {
        Action finishAction;
        if (null != this.current) {
            this.m_mainPanel.remove(this.current);
        }
        this.current = wp;
        if (null == this.current) {
            this.current = new NullWizardPanel();
        }
        this.m_mainPanel.add((Component)this.current, "Center");
        this.displayDescription();
        EventObject event = new EventObject(this);
        this.m_listeners.fireEvent(WizardListener.class, event, this.wizardPanelChangedInformer);
        this.setVisible(true);
        this.revalidate();
        this.updateUI();
        this.setDefaultButtonsStates();
        this.invokePendingButtonEvents();
        this.current.display();
        Action nextAction = this.current.getNextButtonAction();
        if (nextAction != null) {
            nextAction.putValue("Name", this.nextButton.getText());
            this.nextButton.setAction(nextAction);
        }
        if ((finishAction = this.current.getFinishButtonAction()) != null) {
            finishAction.putValue("Name", this.finishButton.getText());
            this.finishButton.setAction(finishAction);
        }
        this.focusFirstComponent(this.current);
    }

    private boolean focusFirstComponent(JComponent container) {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (this.m_focusManager.isContainer(comps[i])) {
                if (!this.focusFirstComponent((JComponent)comps[i])) continue;
                return true;
            }
            if (!this.m_focusManager.isFocusable(comps[i])) continue;
            this.m_focusManager.setFocus((JComponent)comps[i]);
            return true;
        }
        return false;
    }

    private void setDefaultButtonsStates() {
        this.cancelButton.setEnabled(true);
        this.cancelButton.setVisible(true);
        this.cancelButton.setText(CANCEL);
        this.helpButton.setEnabled(this.current.hasHelp());
        this.helpButton.setVisible(this.current.hasHelp());
        this.helpButton.setText(HELP);
        this.backButton.setEnabled(this.previous.size() > 0);
        this.backButton.setVisible(true);
        this.backButton.setText(BACK);
        this.nextButton.setAction(null);
        this.nextButton.setEnabled(this.current.hasNext());
        this.nextButton.setVisible(true);
        this.nextButton.setText(NEXT);
        this.applyButton.setVisible(false);
        this.applyButton.setText(APPLY);
        this.finishButton.setEnabled(this.current.canFinish());
        this.finishButton.setVisible(true);
        this.finishButton.setText(FINISH);
        this.updateMnemonics();
    }

    private WizardPanel popStack() {
        WizardPanel wp = this.previous.pop();
        this.ctx.removeWizardPanel(wp);
        return wp;
    }

    private void pushStack(WizardPanel wp) {
        this.previous.push(wp);
        this.ctx.addWizardPanel(wp);
    }

    private void back() {
        this.current.back();
        this.current.removeListeners();
        this.back(this.current.getBackPanel());
    }

    private void back(WizardPanel goBack) {
        WizardPanel wp = null;
        if (goBack != null) {
            ArrayList<WizardPanel> skipedPrevPanels = new ArrayList<WizardPanel>();
            if (this.previous.contains(goBack)) {
                while ((wp = this.popStack()) != goBack) {
                    skipedPrevPanels.add(wp);
                }
            } else {
                return;
            }
            WizardPanel nextDisplayablePanel = wp;
            while (!nextDisplayablePanel.isDisplayable()) {
                if (!this.runWizardTransactions(nextDisplayablePanel)) {
                    int i = skipedPrevPanels.size();
                    while (i-- > 0) {
                        this.pushStack((WizardPanel)skipedPrevPanels.get(i));
                    }
                    return;
                }
                this.pushStack(nextDisplayablePanel);
                skipedPrevPanels.remove(skipedPrevPanels.size() - 1);
                WizardPanel prevPanel = nextDisplayablePanel;
                nextDisplayablePanel = prevPanel.next();
                nextDisplayablePanel.setWizardContext(this.ctx);
                nextDisplayablePanel.initSummary(prevPanel);
                nextDisplayablePanel.setWizardButtonsListener(this);
                prevPanel.removeListeners();
            }
            wp = nextDisplayablePanel;
        } else {
            while (!(wp = this.popStack()).isDisplayable()) {
                WizardPanel backPanel = wp.getBackPanel();
                if (backPanel == null) continue;
                this.back(backPanel);
                return;
            }
        }
        WizardPanel prev = this.current;
        this.setPanel(wp);
        this.displaySummaryText(wp);
        prev.exit();
    }

    private void apply() {
        this.current.apply();
    }

    private void next() {
        ArrayList list = new ArrayList();
        if (this.current.validateNext(list)) {
            WizardPanel nextPanel;
            int answer;
            String confirmMessage = this.current.getConfirmMessage();
            if (confirmMessage != null && (answer = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.current), confirmMessage, "Warning", 0, 2)) == 1) {
                return;
            }
            if (!this.runWizardTransactions(this.current)) {
                return;
            }
            if (this.current.isSavedAsPervious()) {
                this.pushStack(this.current);
            }
            WizardPanel prevPanel = this.current;
            this.current.removeListeners();
            for (nextPanel = this.current.next(); nextPanel != null && !nextPanel.isDisplayable(); nextPanel = nextPanel.next()) {
                this.pushStack(nextPanel);
                nextPanel.setWizardContext(this.ctx);
                nextPanel.setWizardButtonsListener(this);
                if (!this.runWizardTransactions(nextPanel)) {
                    return;
                }
                nextPanel.initSummary(prevPanel);
                prevPanel = nextPanel;
                prevPanel.removeListeners();
                prevPanel.exit();
            }
            final WizardPanel wp = nextPanel;
            final WizardPanel fPrevPanel = prevPanel;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != wp) {
                        wp.setWizardContext(Wizard.this.ctx);
                        wp.setWizardButtonsListener(Wizard.this);
                        wp.initSummary(fPrevPanel);
                    }
                    WizardPanel prev = Wizard.this.current;
                    Wizard.this.setPanel(wp);
                    if (null != wp) {
                        wp.updateSummary();
                        Wizard.this.displaySummaryText(wp);
                    }
                    prev.exit();
                }
            });
        } else {
            this.showErrorMessages(list);
        }
    }

    private boolean runWizardTransactions(WizardPanel wp) {
        for (WizardTransaction transaction : wp.getWizardTransactions()) {
            transaction.run();
            if (transaction.isSuccess()) continue;
            return false;
        }
        return true;
    }

    private void invokePendingButtonEvents() {
        int i = this.m_pendingEnableStateEvents.size();
        while (i-- > 0) {
            this.buttonsEnableStateChanged((WizardButtonsEvent)this.m_pendingEnableStateEvents.get(i));
        }
        this.m_pendingEnableStateEvents.clear();
        i = this.m_pendingVisibilityEvents.size();
        while (i-- > 0) {
            this.buttonsVisibilityChanged((WizardButtonsEvent)this.m_pendingVisibilityEvents.get(i));
        }
        this.m_pendingVisibilityEvents.clear();
        i = this.m_pendingTextChangeEvents.size();
        while (i-- > 0) {
            this.buttonsTextChanged((WizardButtonsEvent)this.m_pendingTextChangeEvents.get(i));
        }
        this.m_pendingTextChangeEvents.clear();
    }

    private void finish() {
        if (this.runWizardTransactions(this.current)) {
            ArrayList list = new ArrayList();
            if (this.current.validateFinish(list)) {
                this.current.finish();
                EventObject event = new EventObject(this);
                this.m_listeners.fireEvent(WizardListener.class, event, this.wizardFinishedInformer);
            } else {
                this.showErrorMessages(list);
            }
        }
    }

    private void cancel() {
        EventObject event = new EventObject(this);
        this.m_listeners.fireEvent(WizardListener.class, event, this.wizardCancelledInformer);
    }

    private void help() {
        this.current.help();
    }

    private void showErrorMessages(ArrayList list) {
        Window w = SwingUtilities.windowForComponent(this);
        ErrorMessageBox errorMsgBox = null;
        errorMsgBox = w instanceof Frame ? new ErrorMessageBox((Frame)w) : (w instanceof Dialog ? new ErrorMessageBox((Dialog)w) : new ErrorMessageBox());
        errorMsgBox.showErrorMessages(list);
    }

    public WizardPanel getCurrentPanel() {
        return this.current;
    }

    @Override
    public void buttonsEnableStateChanged(WizardButtonsEvent e) {
        HashMap map = e.getButtonsMap();
        if (map.containsKey(NEXT_I18N)) {
            this.nextButton.setEnabled((Boolean)map.get(NEXT_I18N));
        }
        if (map.containsKey(APPLY_I18N)) {
            this.applyButton.setEnabled((Boolean)map.get(APPLY_I18N));
        }
        if (map.containsKey(FINISH_I18N)) {
            this.finishButton.setEnabled((Boolean)map.get(FINISH_I18N));
        }
        if (map.containsKey(CANCEL_I18N)) {
            this.cancelButton.setEnabled((Boolean)map.get(CANCEL_I18N));
        }
        if (map.containsKey(BACK_I18N)) {
            this.backButton.setEnabled((Boolean)map.get(BACK_I18N));
        }
        if (map.containsKey(HELP_I18N)) {
            this.helpButton.setEnabled((Boolean)map.get(HELP_I18N));
        }
    }

    @Override
    public void buttonsVisibilityChanged(WizardButtonsEvent e) {
        HashMap map = e.getButtonsMap();
        if (map.containsKey(NEXT_I18N)) {
            this.nextButton.setVisible((Boolean)map.get(NEXT_I18N));
        }
        if (map.containsKey(APPLY_I18N)) {
            this.applyButton.setVisible((Boolean)map.get(APPLY_I18N));
        }
        if (map.containsKey(FINISH_I18N)) {
            this.finishButton.setVisible((Boolean)map.get(FINISH_I18N));
        }
        if (map.containsKey(CANCEL_I18N)) {
            this.cancelButton.setVisible((Boolean)map.get(CANCEL_I18N));
        }
        if (map.containsKey(HELP_I18N)) {
            this.helpButton.setVisible((Boolean)map.get(HELP_I18N));
        }
        if (map.containsKey(BACK_I18N)) {
            this.backButton.setVisible((Boolean)map.get(BACK_I18N));
        }
    }

    @Override
    public void buttonsTextChanged(WizardButtonsEvent e) {
        HashMap map = e.getButtonsMap();
        if (map.containsKey(NEXT_I18N)) {
            this.nextButton.setText((String)map.get(NEXT_I18N));
        }
        if (map.containsKey(APPLY_I18N)) {
            this.applyButton.setText((String)map.get(APPLY_I18N));
        }
        if (map.containsKey(FINISH_I18N)) {
            this.finishButton.setText((String)map.get(FINISH_I18N));
        }
        if (map.containsKey(CANCEL_I18N)) {
            this.cancelButton.setText((String)map.get(CANCEL_I18N));
        }
        if (map.containsKey(HELP_I18N)) {
            this.helpButton.setText((String)map.get(HELP_I18N));
        }
        if (map.containsKey(BACK_I18N)) {
            this.backButton.setText((String)map.get(BACK_I18N));
        }
        this.updateMnemonics();
    }

    public void updateMnemonics() {
        JButton[] buttons = new JButton[]{this.nextButton, this.applyButton, this.finishButton, this.cancelButton, this.helpButton, this.backButton};
        HashSet<Character> usedChars = new HashSet<Character>();
        for (int i = 0; i < buttons.length; ++i) {
            Character mnemonicChar = this.findCharacterNotInUse(buttons[i].getText(), usedChars);
            if (mnemonicChar != null) {
                usedChars.add(mnemonicChar);
                buttons[i].setMnemonic(mnemonicChar.charValue());
                continue;
            }
            buttons[i].setMnemonic(-1);
        }
    }

    private Character findCharacterNotInUse(String str, Set usedChars) {
        if (str == null) {
            return null;
        }
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char letter = Character.toUpperCase(charArray[i]);
            Character candidate = new Character(letter);
            if (!Character.isLetter(letter) || usedChars.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public void removeMnemonics() {
        JButton[] buttons = new JButton[]{this.nextButton, this.applyButton, this.finishButton, this.cancelButton, this.helpButton, this.backButton};
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setMnemonic(-1);
        }
    }

    @Override
    public void buttonPerformAction(WizardButtonsEvent e) {
        String btt = e.getActionCommand();
        if (btt.equals(NEXT_I18N)) {
            this.next();
        }
        if (btt.equals(FINISH_I18N)) {
            this.finish();
        }
        if (btt.equals(CANCEL_I18N)) {
            this.cancel();
        }
        if (btt.equals(HELP_I18N)) {
            this.help();
        }
        if (btt.equals(BACK_I18N)) {
            this.back();
        }
    }

    @Override
    public void invokeEnableStateChangeLater(WizardButtonsEvent e) {
        this.m_pendingEnableStateEvents.add(e);
    }

    @Override
    public void invokeTextChangeLater(WizardButtonsEvent e) {
        this.m_pendingTextChangeEvents.add(e);
    }

    @Override
    public void invokeVisibilityChangeLater(WizardButtonsEvent e) {
        this.m_pendingVisibilityEvents.add(e);
    }

    public SrComponentStatusBarPanel getStatusBarPanel() {
        return this.m_statusPanel;
    }

    public void setTransactionMonitor(WizardTransactionMonitor monitor) {
        this.m_transactionMonitor = monitor;
    }

    private static class WizardFocusManager {
        private WizardFocusManager() {
        }

        private boolean isFocusable(Component c) {
            if (c instanceof JTable) {
                if (((JTable)c).getRowCount() == 0) {
                    return false;
                }
            } else if (c instanceof JTree) {
                JTree tree = (JTree)c;
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                TreeNode root = (TreeNode)model.getRoot();
                if (!tree.isRootVisible() && model.isLeaf(root)) {
                    return false;
                }
            }
            return c.isEnabled() && c.isFocusable() && c.isVisible() && c instanceof JComponent && !(c instanceof JLabel);
        }

        private void setFocus(JComponent c) {
            if (c instanceof JTable) {
                if (((JTable)c).getRowCount() > 0) {
                    ((JTable)c).setRowSelectionInterval(0, 0);
                    c.grabFocus();
                    return;
                }
            } else if (c instanceof JTree) {
                JTree tree = (JTree)c;
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                TreeNode root = (TreeNode)model.getRoot();
                if (tree.isRootVisible()) {
                    tree.setSelectionPath(new TreePath(model.getPathToRoot(root)));
                    tree.grabFocus();
                } else {
                    Enumeration<? extends TreeNode> e = root.children();
                    if (e.hasMoreElements()) {
                        TreePath path = new TreePath(model.getPathToRoot(e.nextElement()));
                        tree.setSelectionPath(path);
                        tree.grabFocus();
                        return;
                    }
                }
            }
            c.grabFocus();
        }

        private boolean isContainer(Component c) {
            return c instanceof JPanel || c instanceof JScrollPane || c instanceof JViewport || c instanceof JSplitPane;
        }
    }

    public static class SummaryTableColumns
    extends SrDefaultTableColumns {
        private static Vector<String> columns = new Vector();

        public SummaryTableColumns() {
            super((List<String>)columns);
        }

        static {
            columns.add("Parameter");
            columns.add("Value");
        }
    }
}

