/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.log.SrLogger;
import com.sanrad.swing.components.SrActionComboBox;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public abstract class SrTreeComboBox
extends SrActionComboBox {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final int theIndentationSize = 15;
    private Insets myCellInsets = new Insets(3, 5, 2, 50);
    protected Class myContext;
    private HashMap<Object, TreeNodeAction> myItemToActionMap = new HashMap();
    private TreeNodeProperties myTreeNodeProperties;

    public SrTreeComboBox(Class aContext) {
        this(aContext, null);
    }

    public SrTreeComboBox(Class aContext, TreeNodeProperties aNodeProperties) {
        this.setTreeNodeProperties(aNodeProperties);
        this.setContext(aContext);
        this.setRenderer(new TreeNodeRenderer((DefaultListCellRenderer)this.getRenderer()));
    }

    @Override
    public void addItem(Object anObject) {
        super.addItem(anObject);
        this.handleAddedItem(anObject);
    }

    public void addTreeNodeItem(Object aNode) {
        this.addItem(new TreeNodeAction(aNode));
    }

    public void insertTreeNodeItemAt(Object aNode, int index) {
        this.insertItemAt(new TreeNodeAction(aNode), index);
    }

    @Override
    public final void insertItemAt(Object anObject, int index) {
        super.insertItemAt(anObject, index);
        this.handleAddedItem(anObject);
    }

    @Override
    public final void removeItem(Object anObject) {
        TreeNodeAction itemAction = this.myItemToActionMap.get(anObject);
        if (itemAction != null) {
            super.removeItem(itemAction);
        } else {
            super.removeItem(anObject);
        }
    }

    public final Object getItemAt(int index) {
        Object item = super.getItemAt(index);
        if (item instanceof TreeNodeAction) {
            return ((TreeNodeAction)item).getTreeItem();
        }
        return item;
    }

    public Object getEnabledSelectedItem() {
        Object selectedNode = this.getItemAt(this.getSelectedIndex());
        if (selectedNode != null && this.isEnabledNode(selectedNode)) {
            return selectedNode;
        }
        return null;
    }

    protected boolean isEnabledNode(Object aNode) {
        return this.myTreeNodeProperties.getDisabledToolTip(aNode) == null;
    }

    protected abstract int getIndentationForNode(Object var1);

    public Insets getCellInsets() {
        return new Insets(this.myCellInsets.top, this.myCellInsets.left, this.myCellInsets.bottom, this.myCellInsets.right);
    }

    public void setTreeNodeProperties(TreeNodeProperties aTreeNodeProperties) {
        this.myTreeNodeProperties = aTreeNodeProperties;
        if (this.myTreeNodeProperties == null) {
            this.myTreeNodeProperties = new TreeNodeProperties(){

                public String getDisabledToolTip(Object aNode) {
                    return null;
                }

                public String getTextForNode(Object aNode) {
                    return aNode.toString();
                }

                public Icon getNodeIcon(Object aNode) {
                    return null;
                }
            };
        }
    }

    public void setCellInsets(Insets aCellInsets) {
        this.myCellInsets = aCellInsets;
    }

    private void handleAddedItem(Object anObject) {
        if (anObject instanceof TreeNodeAction) {
            TreeNodeAction action = (TreeNodeAction)anObject;
            this.myItemToActionMap.put(action.getTreeItem(), action);
        }
    }

    @Override
    public void setSelectedItem(Object aNode) {
        if (aNode != null) {
            TreeNodeAction action = this.myItemToActionMap.get(aNode);
            if (action != null) {
                super.setSelectedItem(action);
            } else {
                super.setSelectedItem(aNode);
            }
        } else {
            super.setSelectedItem(null);
        }
    }

    @Override
    public Object getSelectedItem() {
        Object selectedItem = super.getSelectedItem();
        if (selectedItem instanceof TreeNodeAction) {
            return ((TreeNodeAction)selectedItem).getTreeItem();
        }
        return selectedItem;
    }

    @Override
    protected void selectedItemChanged() {
        super.selectedItemChanged();
        if (this.dataModel.getSelectedItem() == null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
    }

    private void setContext(Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("The context cannot be null");
        }
        this.myContext = aClass;
    }

    protected void comboboxTreeNodesChanged() {
        for (TreeNodeAction action : this.myItemToActionMap.values()) {
            action.updateActionProperties();
        }
    }

    public static interface TreeNodeProperties<T> {
        public String getDisabledToolTip(T var1);

        public String getTextForNode(T var1);

        public Icon getNodeIcon(T var1);
    }

    private class TreeNodeRenderer
    implements ListCellRenderer {
        DefaultListCellRenderer myOriginalRenderer;

        private TreeNodeRenderer(DefaultListCellRenderer aOriginalRenderer) {
            this.myOriginalRenderer = aOriginalRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object treeNodeItem = null;
            if (value instanceof TreeNodeAction) {
                treeNodeItem = ((TreeNodeAction)value).getTreeItem();
            }
            this.myOriginalRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (treeNodeItem != null) {
                this.setIndentation(SrTreeComboBox.this.getIndentationForNode(treeNodeItem));
            }
            return this.myOriginalRenderer;
        }

        private void setIndentation(int aIndentation) {
            if (aIndentation > 0) {
                this.myOriginalRenderer.setBorder(BorderFactory.createEmptyBorder(((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.top, ((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.left + aIndentation * 15, ((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.bottom, ((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.right));
            } else {
                this.myOriginalRenderer.setBorder(BorderFactory.createEmptyBorder(((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.top, ((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.left, ((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.bottom, ((SrTreeComboBox)SrTreeComboBox.this).myCellInsets.right));
            }
        }
    }

    private class TreeNodeAction
    extends AbstractAction {
        private Object myTreeItem;

        TreeNodeAction(Object aNode) {
            this.myTreeItem = aNode;
            this.updateActionProperties();
        }

        void updateActionProperties() {
            Object treeNode = this.getTreeItem();
            String text = SrTreeComboBox.this.myTreeNodeProperties.getTextForNode(treeNode);
            if (text != null) {
                this.putValue("Name", text);
            } else {
                this.putValue("Name", treeNode.toString());
            }
            String disabledMsg = SrTreeComboBox.this.myTreeNodeProperties.getDisabledToolTip(treeNode);
            this.setEnabled(disabledMsg == null);
            this.putValue("ShortDescription", disabledMsg);
            this.putValue("SmallIcon", SrTreeComboBox.this.myTreeNodeProperties.getNodeIcon(treeNode));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SrTreeComboBox.this.fireItemStateChanged(new ItemEvent(SrTreeComboBox.this, 701, this.myTreeItem, 1));
        }

        Object getTreeItem() {
            return this.myTreeItem;
        }

        public String toString() {
            return this.myTreeItem.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TreeNodeAction) {
                return ((TreeNodeAction)obj).getTreeItem().equals(this.getTreeItem());
            }
            return false;
        }
    }
}

