/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComboSetPanel;
import com.sanrad.swing.components.SrComponent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SrTimeField
extends SrComboSetPanel {
    private static final String[] HOURS = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private static final String[] MINUTES_SECONDS = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private static final String SEPARATOR = ":";
    private static final Object[][] COMBO_VALUES = new String[][]{HOURS, MINUTES_SECONDS, MINUTES_SECONDS};

    public SrTimeField() {
        GregorianCalendar cal = new GregorianCalendar();
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        this.init(hours, minutes, seconds);
    }

    public SrTimeField(int hours, int minutes, int seconds) {
        this.init(hours, minutes, seconds);
    }

    private void init(int hours, int minutes, int seconds) {
        this.getComboByIndex(0).setSelectedItem(this.getTimeVal(hours));
        String min = this.getTimeVal(minutes);
        this.getComboByIndex(1).setSelectedItem(min);
        String sec = this.getTimeVal(seconds);
        this.getComboByIndex(2).setSelectedItem(sec);
    }

    @Override
    public Object getValue() {
        SrComboBox hour = (SrComboBox)this.m_combos.get(0);
        SrComboBox minute = (SrComboBox)this.m_combos.get(1);
        SrComboBox second = (SrComboBox)this.m_combos.get(2);
        return SrTimeField.getTimeString((String)hour.getSelectedItem(), (String)minute.getSelectedItem(), (String)second.getSelectedItem());
    }

    public static String getTimeString(String hour, String minute, String second) {
        StringBuffer buff = new StringBuffer();
        buff.append(hour);
        buff.append(SEPARATOR);
        buff.append(minute);
        buff.append(SEPARATOR);
        buff.append(second);
        return buff.toString();
    }

    private String getTimeVal(int val) {
        String str = String.valueOf(val);
        if (val < 10 && str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    @Override
    protected Object[][] getComboValues() {
        return COMBO_VALUES;
    }

    @Override
    protected String getSeparator() {
        return SEPARATOR;
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrTimeField) {
            String myObj = (String)this.getValue();
            String[] hhmmss = myObj.split(SEPARATOR);
            GregorianCalendar myCal = new GregorianCalendar();
            myCal.set(10, Integer.parseInt(hhmmss[0]));
            myCal.set(12, Integer.parseInt(hhmmss[1]));
            myCal.set(13, Integer.parseInt(hhmmss[2]));
            Date myDate = myCal.getTime();
            String comObj = (String)com.getValue();
            hhmmss = comObj.split(SEPARATOR);
            GregorianCalendar comCal = new GregorianCalendar();
            comCal.set(10, Integer.parseInt(hhmmss[0]));
            comCal.set(12, Integer.parseInt(hhmmss[1]));
            comCal.set(13, Integer.parseInt(hhmmss[2]));
            Date comDate = comCal.getTime();
            answer = myDate.compareTo(comDate);
        }
        return answer;
    }

    public int[] getCurrentTimeValue() {
        String myObj = (String)this.getValue();
        String[] hhmmss = myObj.split(SEPARATOR);
        int[] myCal = new int[]{Integer.parseInt(hhmmss[0]), Integer.parseInt(hhmmss[1]), Integer.parseInt(hhmmss[2])};
        return myCal;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Date) {
            this.setTime(((Date)value).getTime());
        } else {
            super.setValue(value);
        }
    }

    public void setTime(long timeMilliSec) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMilliSec);
        this.init(c.get(11), c.get(12), c.get(13));
    }
}

