/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;

public class SrTextField
extends JTextField
implements SrComponent {
    public SrTextField() {
        this.init();
    }

    public SrTextField(String text) {
        super(text);
        this.init();
    }

    public SrTextField(int cols) {
        super(cols);
        this.init();
    }

    public SrTextField(boolean editable) {
        this.setEditable(editable);
        this.init();
    }

    private void init() {
        this.putClientProperty("substancelaf.noExtraElements", Boolean.TRUE);
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled);
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        if (this.getDocument() != null) {
            String text = this.getText();
            this.setToolTipText(b || text.isEmpty() ? null : text);
        }
        this.setForeground(b ? UIManager.getColor("TextField.foreground") : UIManager.getColor("Label.disabledForeground"));
    }

    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        Object val = value != null ? value : "";
        this.setText(val.toString());
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    @Override
    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        String txt = this.getText();
        return txt != null && txt.length() > 0;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrTextField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }
}

