/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SrTextAreaField
extends JScrollPane
implements SrComponent {
    private JTextArea m_textArea;

    public SrTextAreaField() {
        this(8, 10);
        this.init();
    }

    public SrTextAreaField(String text) {
        this(null, text, 8, 10);
        this.init();
    }

    public SrTextAreaField(int rows, int columns) {
        this(null, "", rows, columns);
        this.init();
    }

    public SrTextAreaField(String text, int rows, int columns) {
        this(null, text, rows, columns);
        this.init();
    }

    public SrTextAreaField(Document doc) {
        this(doc, "", 8, 10);
        this.init();
    }

    public SrTextAreaField(Document doc, String text, int rows, int columns) {
        this.m_textArea = new JTextArea(doc, text, rows, columns);
        this.m_textArea.setFont(LookAndFill.GENERAL_FONT);
        this.setViewportView(this.m_textArea);
    }

    private void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public JTextArea getTextArea() {
        return this.m_textArea;
    }

    public Object getValue() {
        return this.m_textArea.getText();
    }

    public void setValue(Object value) {
        this.m_textArea.setText((String)value);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
        this.m_textArea.setEditable(enable);
        this.m_textArea.setEnabled(enable);
    }

    @Override
    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        boolean valid = false;
        String txt = this.m_textArea.getText();
        if (txt != null && txt.length() > 0) {
            valid = true;
        }
        return valid;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.m_textArea.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.m_textArea.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.m_textArea.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.m_textArea.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrTextAreaField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public void setLineWrap(boolean wrap) {
        this.m_textArea.setLineWrap(wrap);
        this.m_textArea.setWrapStyleWord(wrap);
    }

    public void setEditable(boolean editable) {
        this.m_textArea.setEditable(editable);
    }
}

