/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrRadioButton;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SrRadioButtonsPanel
extends JPanel
implements SrComponent {
    private ButtonGroup m_bttGroup;
    private HashMap<SrRadioButton, Object> m_buttonValuesMap = new HashMap();
    private ArrayList<SrRadioButton> m_buttonsOrderedList = new ArrayList();
    private ButtonKeyListener m_keyListener = new ButtonKeyListener();
    private boolean isVerticalLayout;

    public SrRadioButtonsPanel() {
        this(1);
    }

    public SrRadioButtonsPanel(int aAlignment) {
        if (1 == aAlignment) {
            this.setLayout(new BoxLayout(this, 1));
            this.isVerticalLayout = true;
        } else if (0 == aAlignment) {
            this.setLayout(new BoxLayout(this, 0));
            this.isVerticalLayout = false;
        } else {
            throw new IllegalArgumentException(aAlignment + " is not a legal alignment value");
        }
        this.setOpaque(false);
        this.m_bttGroup = new ButtonGroup();
    }

    public void addRadio(String text, Object value) {
        SrRadioButton radio = new SrRadioButton(text);
        this.appendRadioToPanel(radio, value);
    }

    public void addRadio(Action a, Object value) {
        SrRadioButton radio = new SrRadioButton(a){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelected(boolean b) {
                super.setSelected(b);
                if (b) {
                    this.fireActionPerformed(new ActionEvent(this, 1001, this.getText()));
                }
            }
        };
        this.appendRadioToPanel(radio, value);
    }

    private void appendRadioToPanel(SrRadioButton radio, Object value) {
        radio.setFont(this.getFont());
        this.m_buttonValuesMap.put(radio, value);
        this.m_bttGroup.add(radio);
        this.m_buttonsOrderedList.add(radio);
        this.add(radio);
        radio.addKeyListener(this.m_keyListener);
    }

    public void setTitle(String title) {
        this.setBorder(new TitledBorder(null, title, 0, 0, LookAndFill.GENERAL_FONT));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.m_bttGroup != null) {
            Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
            while (iter.hasMoreElements()) {
                SrRadioButton radio = (SrRadioButton)iter.nextElement();
                radio.setFont(font);
            }
        }
    }

    public void removeRadio(String des) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            String name = radio.getText();
            if (!name.equals(des)) continue;
            this.m_bttGroup.remove(radio);
            this.m_buttonValuesMap.remove(radio);
            this.remove(radio);
            break;
        }
    }

    public Object getValue() {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            if (!radio.isSelected()) continue;
            return this.m_buttonValuesMap.get(radio);
        }
        return null;
    }

    public void setValue(Object value) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            if (!value.equals(this.m_buttonValuesMap.get(radio)) && !value.equals(radio.getText())) continue;
            radio.setSelected(true);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            radio.setEnabled(enable);
        }
    }

    @Override
    public boolean isComponentEnabled() {
        return ((SrRadioButton)this.m_bttGroup.getElements().nextElement()).isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        return this.getValue() != null;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            radio.addComponentFocusListener(fl);
        }
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            radio.addComponentValidListener(l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            radio.removeComponentFocusListener(fl);
        }
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        Enumeration<AbstractButton> iter = this.m_bttGroup.getElements();
        while (iter.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)iter.nextElement();
            radio.removeComponentValidListener(l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrRadioButtonsPanel) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    private class ButtonKeyListener
    implements KeyListener {
        private ButtonKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source = e.getSource();
            if (source instanceof SrRadioButton) {
                int indexOf;
                if (e.getKeyCode() == 40 && SrRadioButtonsPanel.this.isVerticalLayout || e.getKeyCode() == 39 && !SrRadioButtonsPanel.this.isVerticalLayout) {
                    int indexOf2 = SrRadioButtonsPanel.this.m_buttonsOrderedList.indexOf(source);
                    if (indexOf2 > -1 && indexOf2 < SrRadioButtonsPanel.this.m_buttonsOrderedList.size() - 1) {
                        ((SrRadioButton)SrRadioButtonsPanel.this.m_buttonsOrderedList.get(indexOf2 + 1)).grabFocus();
                    }
                } else if ((e.getKeyCode() == 38 && SrRadioButtonsPanel.this.isVerticalLayout || e.getKeyCode() == 37 && !SrRadioButtonsPanel.this.isVerticalLayout) && (indexOf = SrRadioButtonsPanel.this.m_buttonsOrderedList.indexOf(source)) > 0) {
                    ((SrRadioButton)SrRadioButtonsPanel.this.m_buttonsOrderedList.get(indexOf - 1)).grabFocus();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

