/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.util.SrResourceBundle;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

public class SrRadioButton
extends JRadioButton
implements SrComponent {
    public SrRadioButton() {
        this.init();
    }

    public SrRadioButton(String text) {
        this();
        this.setText(text);
    }

    public SrRadioButton(Action act) {
        this();
        this.setAction(act);
    }

    protected void init() {
        this.setFont(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getFontResource(SrDefaultUIBundleKeys.GENERAL_FONT));
        this.setBackground(LookAndFill.DIALOG_COLOR);
    }

    public Object getValue() {
        return Boolean.toString(this.isSelected());
    }

    public void setValue(Object value) {
        this.setSelected(Boolean.getBoolean((String)value));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    @Override
    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        return true;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof ChangeListener) {
            this.getModel().addChangeListener((ChangeListener)l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ChangeListener) {
            this.getModel().removeChangeListener((ChangeListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrRadioButton) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }
}

