/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SrProgressDotsPanel
extends JPanel {
    static int TIMER_DELAY = 250;
    private JLabel m_label = new JLabel();
    private Progress progress;
    private boolean progressEnabled = true;

    public SrProgressDotsPanel(String text, int numberOfDots, int diameter) {
        this(numberOfDots, diameter);
        this.m_label.setText(text);
    }

    public SrProgressDotsPanel(int numberOfDots, int diameter) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add(this.m_label);
        this.m_label.setOpaque(false);
        this.progress = new Progress();
        this.progress.dots = numberOfDots;
        this.progress.diameter = diameter;
    }

    public void setText(String text) {
        this.m_label.setText(text);
        this.updateSizeAndLocation();
    }

    public String getText() {
        return this.m_label.getText();
    }

    public void startProgress() {
        this.progress.start();
    }

    public void walk() {
        this.progress.walk();
        this.repaint();
    }

    public void setValue(int value) {
        this.progress.counter = value;
        this.repaint();
    }

    public void stopPorgress() {
        this.progress.stop();
    }

    public void setProgressEnabled(boolean b) {
        this.progressEnabled = b;
        this.repaint();
    }

    public void setLabelFont(Font font) {
        this.m_label.setFont(font);
        this.updateSizeAndLocation();
    }

    public void setProgressForeground(Color fg) {
        this.m_label.setForeground(fg);
        this.updateSizeAndLocation();
    }

    private void updateSizeAndLocation() {
        FontMetrics fm = this.m_label.getFontMetrics(this.m_label.getFont());
        this.setPreferredSize(new Dimension(fm.stringWidth(this.m_label.getText()) + this.progress.getMaxWidth(), fm.getHeight()));
        Dimension label = this.m_label.getPreferredSize();
        int progressX = this.m_label.getLocation().x + label.width;
        int progressY = this.m_label.getLocation().y + fm.getHeight() - fm.getDescent() - this.progress.diameter;
        this.progress.location = new Point(progressX, progressY);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.progressEnabled) {
            this.progress.paintProgress(g);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("TEST");
        f.getContentPane().setLayout(new FlowLayout());
        final SrProgressDotsPanel prog = new SrProgressDotsPanel(13, 4);
        f.setBounds(200, 200, 1000, 500);
        f.getContentPane().add(prog);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        Timer timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                prog.setText("Start");
                prog.startProgress();
            }
        });
        timer.setRepeats(false);
        timer.setInitialDelay(1000);
        timer.start();
        Timer timer2 = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                prog.setText("Start Start");
                prog.setLabelFont(new Font("Courier New", 1, 24));
                prog.setLabelFont(prog.m_label.getFont().deriveFont(prog.m_label.getFont().getSize() + 2));
            }
        });
        timer2.setRepeats(false);
        timer2.setInitialDelay(8000);
        timer2.start();
    }

    private class TimerActionListener
    implements ActionListener {
        Timer m_timer;
        Progress m_progress;

        private TimerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_progress.counter % (((SrProgressDotsPanel)SrProgressDotsPanel.this).progress.dots + 1) == ((SrProgressDotsPanel)SrProgressDotsPanel.this).progress.dots) {
                this.m_timer.setDelay(TIMER_DELAY / 2);
            } else {
                this.m_timer.setDelay(TIMER_DELAY);
            }
            SrProgressDotsPanel.this.progress.walk();
            SrProgressDotsPanel.this.repaint();
        }
    }

    private class ProgressTimer
    extends Timer {
        ProgressTimer(TimerActionListener listener, Progress progress) {
            super(TIMER_DELAY, listener);
            listener.m_timer = this;
            listener.m_progress = progress;
        }
    }

    private class Progress {
        int dots = 6;
        int diameter = 4;
        int counter = 0;
        ProgressTimer timer;
        Point location;

        private Progress() {
        }

        void paintProgress(Graphics g) {
            Color prevColor = g.getColor();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(SrProgressDotsPanel.this.m_label.getForeground());
            for (int i = 0; i < this.counter % (this.dots + 1); ++i) {
                int nextPointX = this.location.x + this.diameter / 2 + i * (this.diameter + this.diameter / 2);
                g.fillOval(nextPointX, this.location.y, this.diameter, this.diameter);
            }
            g.setColor(prevColor);
        }

        void walk() {
            ++this.counter;
            if (this.counter == (this.dots + 1) * 10000) {
                this.counter = 0;
            }
        }

        int getMaxWidth() {
            return this.diameter + this.dots * (this.diameter + this.diameter / 2);
        }

        void start() {
            this.timer = new ProgressTimer(new TimerActionListener(), this);
            this.timer.start();
        }

        void stop() {
            this.counter = this.dots;
            if (this.timer != null) {
                this.timer.stop();
                SrProgressDotsPanel.this.repaint();
            }
        }
    }
}

