/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.text.IntegerDocument;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusListener;
import java.util.EventListener;

public class SrPercentTextField
extends SrPanel
implements SrComponent {
    private SrIntegerTextField m_intField;

    public SrPercentTextField() {
        super(new FlowLayout(0, 0, 0));
        SrLabelField percentLbl = new SrLabelField("%");
        this.m_intField = new SrIntegerTextField(3);
        this.m_intField.setMaxValue(100);
        this.m_intField.setMinValue(0);
        this.add(this.m_intField);
        this.add(percentLbl);
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.m_intField.addComponentFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        this.m_intField.addComponentValidListener(l);
    }

    @Override
    public int compareTo(SrComponent com) {
        return this.m_intField.compareTo(com);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public Object getValue() {
        return this.m_intField.getValue();
    }

    public int getPercentage() {
        String text = this.m_intField.getText();
        if (text.length() > 0) {
            return Integer.parseInt(text);
        }
        return -1;
    }

    @Override
    public boolean isComponentEnabled() {
        return this.m_intField.isComponentEnabled();
    }

    @Override
    public boolean isComponentValid() {
        return this.m_intField.isComponentValid();
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.m_intField.removeComponentFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        this.m_intField.removeComponentValidListener(l);
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.m_intField.setEnableComponent(enable);
    }

    public void setValue(Object value) {
        this.m_intField.setValue(value);
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < 0 || maxValue > 100) {
            throw new IllegalArgumentException("Percentage out of range: " + maxValue);
        }
        ((IntegerDocument)this.m_intField.getDocument()).setMaxValue(maxValue);
    }

    public SrIntegerTextField getInnerComponent() {
        return this.m_intField;
    }
}

