/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentListener;

public class SrPasswordTextField
extends JPasswordField
implements SrComponent {
    public SrPasswordTextField() {
        this.init();
    }

    public SrPasswordTextField(int i) {
        super(i);
        this.init();
    }

    public void setMaxLength(int limit) {
        this.setDocument(new LengthLimitedDocument(limit));
    }

    private void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public Object getValue() {
        return String.valueOf(this.getPassword());
    }

    public void setValue(Object value) {
        this.setText((String)value);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    @Override
    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        boolean valid = false;
        String txt = String.valueOf(this.getPassword());
        if (txt != null && txt.length() > 0) {
            valid = true;
        }
        return valid;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrPasswordTextField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }
}

