/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrLengthLimitedTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.event.DocumentListener;

public class SrMultiTextField
extends SrPanel
implements SrComponent {
    protected String delimiter;
    protected String[] delimiters;
    protected SrLabelField[] delimiterLabels;
    protected SrTextField[] myTextFields;

    public SrMultiTextField(SrTextField[] textFields, String delimiter) {
        this(delimiter);
        this.initMultiTextFields(textFields);
        this.initDelimitersWithSingleDelimiter(delimiter);
    }

    protected SrMultiTextField(String aDelimiter) {
        this.delimiter = aDelimiter;
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (SrMultiTextField.this.myTextFields == null) {
                    return null;
                }
                int focusIndex = this.indexOfTextField((SrTextField)aComponent);
                if (focusIndex < SrMultiTextField.this.myTextFields.length - 1) {
                    return SrMultiTextField.this.myTextFields[focusIndex + 1];
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                if (SrMultiTextField.this.myTextFields == null) {
                    return null;
                }
                int focusIndex = this.indexOfTextField((SrTextField)aComponent);
                if (focusIndex > 0) {
                    return SrMultiTextField.this.myTextFields[focusIndex - 1];
                }
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                if (SrMultiTextField.this.myTextFields == null) {
                    return null;
                }
                return SrMultiTextField.this.myTextFields[0];
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                if (SrMultiTextField.this.myTextFields == null) {
                    return null;
                }
                return SrMultiTextField.this.myTextFields[0];
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                if (SrMultiTextField.this.myTextFields == null) {
                    return null;
                }
                return SrMultiTextField.this.myTextFields[SrMultiTextField.this.myTextFields.length - 1];
            }

            private int indexOfTextField(SrTextField aField) {
                if (SrMultiTextField.this.myTextFields != null) {
                    for (int i = 0; i < SrMultiTextField.this.myTextFields.length; ++i) {
                        if (SrMultiTextField.this.myTextFields[i] != aField) continue;
                        return i;
                    }
                }
                return -1;
            }
        });
        this.setLayout(new BoxLayout(this, 0));
    }

    protected void initMultiTextFields(SrTextField[] textFields) {
        this.myTextFields = textFields;
        if (this.delimiters == null) {
            this.initDelimitersWithSingleDelimiter(this.delimiter);
        }
        this.delimiterLabels = new SrLabelField[textFields.length];
        for (int i = 0; i < textFields.length; ++i) {
            if (i < this.delimiterLabels.length) {
                this.delimiterLabels[i] = new SrLabelField(this.delimiters[i]);
                this.add((Component)this.delimiterLabels[i], null);
            }
            textFields[i].addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SrMultiTextField.this.textField_keyReleased(e);
                }
            });
            this.add((Component)textFields[i], null);
        }
    }

    private void initDelimitersWithSingleDelimiter(String delimiter) {
        this.delimiters = new String[this.myTextFields.length];
        this.delimiters[0] = "";
        int i = this.delimiters.length;
        while (i-- > 1) {
            this.delimiters[i] = delimiter;
        }
    }

    private int getFocusedTextFieldIndex() {
        for (int i = 0; i < this.myTextFields.length; ++i) {
            if (!this.myTextFields[i].hasFocus()) continue;
            return i;
        }
        return -1;
    }

    private void setFocusToNextTextField() {
        int nextFocusIndex = this.getFocusedTextFieldIndex() + 1;
        if (nextFocusIndex < this.myTextFields.length) {
            this.myTextFields[nextFocusIndex].requestFocus();
        }
    }

    private void textField_keyReleased(KeyEvent e) {
        if (!e.isActionKey() && e.getKeyCode() != 16) {
            LengthLimitedDocument document;
            int maxLength;
            if (String.valueOf(e.getKeyChar()).equals(this.delimiter)) {
                if (!this.myTextFields[this.getFocusedTextFieldIndex()].getText().equals("")) {
                    this.setFocusToNextTextField();
                }
            } else if (this.myTextFields[this.getFocusedTextFieldIndex()] instanceof SrLengthLimitedTextField && (maxLength = (document = (LengthLimitedDocument)this.myTextFields[this.getFocusedTextFieldIndex()].getDocument()).getLimit()) != -1 && maxLength == this.myTextFields[this.getFocusedTextFieldIndex()].getText().length()) {
                this.setFocusToNextTextField();
            }
        }
    }

    public void setText(String text) {
        if (text.isEmpty()) {
            for (SrTextField f : this.myTextFields) {
                f.setText("");
            }
        } else {
            StringTokenizer fullText = new StringTokenizer(text, this.delimiter);
            int i = 0;
            while (fullText.hasMoreElements()) {
                String textField = (String)fullText.nextElement();
                this.myTextFields[i++].setText(textField);
            }
        }
    }

    public String getText() {
        StringBuilder fullText = new StringBuilder();
        if (this.isTextSet()) {
            for (int i = 0; i < this.myTextFields.length; ++i) {
                if (i < this.delimiters.length) {
                    fullText.append(this.delimiters[i]);
                }
                fullText.append(this.myTextFields[i].getText());
            }
        }
        return fullText.toString();
    }

    public String getText(int fieldIndex) {
        return this.myTextFields[fieldIndex].getText();
    }

    protected int getFirstEmptyIndex() {
        for (int i = 0; i < this.myTextFields.length; ++i) {
            if (!this.myTextFields[i].getText().trim().equals("")) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void requestFocus() {
        int index = this.getFirstEmptyIndex();
        if (index < 0) {
            index = 0;
        }
        this.myTextFields[index].requestFocus();
    }

    protected boolean isTextSet() {
        return this.getFirstEmptyIndex() < 0;
    }

    public boolean isTextSetCorrectly() {
        boolean allEmpty = true;
        boolean allFilled = true;
        for (int i = 0; i < this.myTextFields.length; ++i) {
            if (this.myTextFields[i].getText().trim().length() > 0) {
                allEmpty = false;
                continue;
            }
            allFilled = false;
        }
        return allEmpty || allFilled;
    }

    @Override
    public void setBackground(Color color) {
        if (this.delimiterLabels != null) {
            for (int i = 0; i < this.delimiterLabels.length; ++i) {
                this.delimiterLabels[i].setBackground(color);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        int i;
        if (this.myTextFields != null) {
            for (i = 0; i < this.myTextFields.length; ++i) {
                this.myTextFields[i].setForeground(color);
            }
        }
        if (this.delimiterLabels != null) {
            for (i = 0; i < this.delimiterLabels.length; ++i) {
                this.delimiterLabels[i].setForeground(color);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        int i;
        if (this.myTextFields != null) {
            for (i = 0; i < this.myTextFields.length; ++i) {
                this.myTextFields[i].setFont(font);
            }
        }
        if (this.delimiterLabels != null) {
            for (i = 0; i < this.delimiterLabels.length; ++i) {
                this.delimiterLabels[i].setFont(font);
            }
        }
    }

    public void setEditable(boolean enable) {
        if (this.myTextFields != null) {
            for (int i = 0; i < this.myTextFields.length; ++i) {
                this.myTextFields[i].setEditable(enable);
            }
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        int i;
        if (this.myTextFields != null) {
            for (i = 0; i < this.myTextFields.length; ++i) {
                this.myTextFields[i].setEnabled(enable);
                this.myTextFields[i].setEditable(enable);
            }
        }
        if (this.delimiterLabels != null) {
            for (i = 0; i < this.delimiterLabels.length; ++i) {
                this.delimiterLabels[i].setEnabled(enable);
            }
        }
    }

    public void addDocumentListener(DocumentListener aListener) {
        if (this.myTextFields != null) {
            for (int i = 0; i < this.myTextFields.length; ++i) {
                this.myTextFields[i].getDocument().addDocumentListener(aListener);
            }
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        this.setText((String)value);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        for (int i = 0; i < this.myTextFields.length; ++i) {
            SrTextField txt = this.myTextFields[i];
            ((JComponent)txt).setEnabled(enable);
        }
    }

    @Override
    public boolean isComponentEnabled() {
        return this.myTextFields[0].isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        boolean valid = true;
        for (int i = 0; i < this.myTextFields.length; ++i) {
            SrTextField srComp = this.myTextFields[i];
            if (srComp.isComponentValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        for (int i = 0; i < this.myTextFields.length; ++i) {
            SrTextField txt = this.myTextFields[i];
            txt.addFocusListener(fl);
        }
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            for (int i = 0; i < this.myTextFields.length; ++i) {
                SrTextField txt = this.myTextFields[i];
                txt.getDocument().addDocumentListener((DocumentListener)l);
            }
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        for (int i = 0; i < this.myTextFields.length; ++i) {
            SrTextField txt = this.myTextFields[i];
            txt.removeFocusListener(fl);
        }
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            for (int i = 0; i < this.myTextFields.length; ++i) {
                SrTextField txt = this.myTextFields[i];
                txt.getDocument().removeDocumentListener((DocumentListener)l);
            }
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrMultiTextField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }
}

