/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.util.SrResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.Document;

public class SrLabelField
extends SrPanel
implements SrComponent {
    private static final String START_HTML = "<html><body>";
    private static final String END_HTML = "</body></html>";
    private static final HashMap<Point, Point> theTextPosToIconGridPos = new HashMap();
    private static final HashMap<Point, Insets> theIconPosToIconInsets = new HashMap();
    private boolean m_htmlMode = true;
    private SrMultiLineLabel myLabel = new SrMultiLineLabel();
    private JLabel myIconLabel = new JLabel();
    private int myVerticalTextPosition = 0;
    private int myHorizontalTextPosition = 11;
    private int myIconTextGap = 4;
    private GridBagConstraints myGridBagConstraints = new GridBagConstraints();

    public SrLabelField() {
        this("");
    }

    public SrLabelField(String text) {
        this.setText(text);
        this.init();
    }

    public void setHorizontalTextPosition(int aPos) {
        boolean isChanged;
        boolean bl = isChanged = aPos != this.myHorizontalTextPosition;
        if (isChanged) {
            this.myHorizontalTextPosition = aPos;
            this.alignIconAndText();
        }
    }

    public void setVerticalTextPosition(int aPos) {
        boolean isChanged;
        boolean bl = isChanged = aPos != this.myVerticalTextPosition;
        if (isChanged) {
            this.myVerticalTextPosition = aPos;
            this.alignIconAndText();
        }
    }

    public void setIcon(Icon aIcon) {
        this.myIconLabel.setIcon(aIcon);
    }

    public void setText(String text) {
        this.myLabel.setText(text);
    }

    public String getText() {
        return this.myLabel.getText();
    }

    public Document getDocument() {
        return this.myLabel.getDocument();
    }

    @Override
    public void setForeground(Color fg) {
        if (this.myLabel != null) {
            this.myLabel.setForeground(fg);
        } else {
            super.setForeground(fg);
        }
    }

    @Override
    public void setFont(Font f) {
        if (this.myLabel != null) {
            this.myLabel.setFont(f);
        } else {
            super.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        if (this.myLabel != null) {
            return this.myLabel.getFont();
        }
        return super.getFont();
    }

    public void setIconTextGap(int aIconTextGap) {
        boolean isChanged;
        boolean bl = isChanged = aIconTextGap != this.myIconTextGap;
        if (isChanged) {
            this.myIconTextGap = aIconTextGap;
            this.alignIconAndText();
        }
    }

    private void alignIconAndText() {
        this.remove(this.myIconLabel);
        Point swingPosPoint = new Point(this.myHorizontalTextPosition, this.myVerticalTextPosition);
        Point iconGridPosition = theTextPosToIconGridPos.get(swingPosPoint);
        this.myGridBagConstraints.gridx = iconGridPosition.x;
        this.myGridBagConstraints.gridy = iconGridPosition.y;
        Insets iconInsets = theIconPosToIconInsets.get(iconGridPosition);
        this.myGridBagConstraints.insets.top = iconInsets.top * this.myIconTextGap;
        this.myGridBagConstraints.insets.left = iconInsets.left * this.myIconTextGap;
        this.myGridBagConstraints.insets.bottom = iconInsets.bottom * this.myIconTextGap;
        this.myGridBagConstraints.insets.right = iconInsets.right * this.myIconTextGap;
        this.add((Component)this.myIconLabel, this.myGridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    private void init() {
        this.myLabel.setLineWrap(false);
        this.setLayout(new GridBagLayout());
        this.myGridBagConstraints.anchor = 18;
        this.myGridBagConstraints.gridx = 1;
        this.myGridBagConstraints.weightx = 1.0;
        this.myGridBagConstraints.gridy = 1;
        this.myGridBagConstraints.fill = 2;
        this.add((Component)this.myLabel, this.myGridBagConstraints);
        this.myGridBagConstraints.fill = 0;
        this.myGridBagConstraints.weightx = 0.0;
        this.alignIconAndText();
        this.myLabel.setFont(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getFontResource(SrDefaultUIBundleKeys.LABEL_FONT));
    }

    protected String getFormattedText(String text) {
        if (text != null) {
            if (this.m_htmlMode) {
                text = text.replaceAll("\n", "<br>");
                return new StringBuffer(START_HTML).append(text).append(END_HTML).toString();
            }
            return text;
        }
        return "";
    }

    public void setHtmlMode(boolean isHTMLMode) {
        String prevText = this.getValue().toString();
        this.m_htmlMode = isHTMLMode;
        this.myLabel.setText(prevText);
    }

    public boolean isHTMLMode() {
        return this.m_htmlMode;
    }

    public Object getValue() {
        String text = null;
        StringBuffer textBuffer = new StringBuffer(this.myLabel.getText());
        int indexOfHtmlStartTag = textBuffer.indexOf(START_HTML);
        int indexOfHtmlEndTag = textBuffer.indexOf(END_HTML);
        if (indexOfHtmlStartTag == 0 && indexOfHtmlEndTag + END_HTML.length() == textBuffer.length()) {
            textBuffer.delete(indexOfHtmlEndTag, textBuffer.length());
            textBuffer.delete(0, START_HTML.length());
            text = textBuffer.toString().replaceAll("<br>", "\n");
        } else {
            text = this.myLabel.getText();
        }
        return text;
    }

    public void setValue(Object value) {
        this.myLabel.setText(value.toString());
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enabled) {
        this.myLabel.setEnabled(enabled);
        this.myIconLabel.setEnabled(enabled);
    }

    @Override
    public boolean isComponentEnabled() {
        return this.myLabel.isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        return true;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.myLabel.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof PropertyChangeListener) {
            this.myLabel.addPropertyChangeListener((PropertyChangeListener)l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.myLabel.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof PropertyChangeListener) {
            this.myLabel.removePropertyChangeListener((PropertyChangeListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrLabelField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    static {
        theTextPosToIconGridPos.put(new Point(2, 1), new Point(2, 2));
        theTextPosToIconGridPos.put(new Point(0, 1), new Point(1, 2));
        theTextPosToIconGridPos.put(new Point(4, 1), new Point(0, 2));
        theTextPosToIconGridPos.put(new Point(10, 1), new Point(2, 2));
        theTextPosToIconGridPos.put(new Point(11, 1), new Point(0, 2));
        theTextPosToIconGridPos.put(new Point(2, 0), new Point(2, 1));
        theTextPosToIconGridPos.put(new Point(0, 0), new Point(0, 1));
        theTextPosToIconGridPos.put(new Point(4, 0), new Point(0, 1));
        theTextPosToIconGridPos.put(new Point(10, 0), new Point(2, 1));
        theTextPosToIconGridPos.put(new Point(11, 0), new Point(0, 1));
        theTextPosToIconGridPos.put(new Point(2, 3), new Point(2, 0));
        theTextPosToIconGridPos.put(new Point(0, 3), new Point(1, 0));
        theTextPosToIconGridPos.put(new Point(4, 3), new Point(0, 0));
        theTextPosToIconGridPos.put(new Point(10, 3), new Point(2, 0));
        theTextPosToIconGridPos.put(new Point(11, 3), new Point(0, 0));
        theIconPosToIconInsets.put(new Point(0, 0), new Insets(0, 0, 1, 1));
        theIconPosToIconInsets.put(new Point(1, 0), new Insets(0, 0, 1, 0));
        theIconPosToIconInsets.put(new Point(2, 0), new Insets(0, 1, 1, 0));
        theIconPosToIconInsets.put(new Point(2, 1), new Insets(0, 1, 0, 0));
        theIconPosToIconInsets.put(new Point(2, 2), new Insets(1, 1, 0, 0));
        theIconPosToIconInsets.put(new Point(1, 2), new Insets(1, 0, 0, 0));
        theIconPosToIconInsets.put(new Point(0, 2), new Insets(1, 0, 0, 1));
        theIconPosToIconInsets.put(new Point(0, 1), new Insets(0, 0, 0, 1));
    }
}

