/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrLengthLimitedTextField;
import com.sanrad.swing.text.IntegerDocument;
import javax.swing.event.DocumentListener;

public class SrIntegerTextField
extends SrLengthLimitedTextField {
    private int minValue = 0;

    public SrIntegerTextField() {
        this.init();
    }

    public SrIntegerTextField(int length) {
        super(length);
        this.init();
    }

    public SrIntegerTextField(int length, int maxValue) {
        this(length);
        this.setMaxValue(maxValue);
    }

    public SrIntegerTextField(int length, int minValue, int maxValue) {
        this(length, maxValue);
        this.minValue = minValue;
    }

    @Override
    protected void setDocument() {
        this.setDocument(new IntegerDocument(this.limit));
    }

    public void setMaxValue(int maxLimit) {
        ((IntegerDocument)this.getDocument()).setMaxValue(maxLimit);
    }

    public void setMinValue(int minLimit) {
        ((IntegerDocument)this.getDocument()).setMinValue(minLimit);
    }

    public void setDocumentListener(DocumentListener listener) {
        this.getDocument().addDocumentListener(listener);
    }

    public int intValue() {
        return Integer.parseInt(this.getText());
    }

    @Override
    public boolean isComponentValid() {
        String txt = this.getText();
        if (this.isIntegerString(txt)) {
            return txt != null && txt.length() > 0 && Integer.parseInt(txt) >= this.minValue;
        }
        return false;
    }

    private boolean isIntegerString(String str) {
        StringBuffer sb = new StringBuffer(str);
        if (sb.length() > 0) {
            if (sb.charAt(0) == '-') {
                if (sb.length() < 2) {
                    return false;
                }
                sb.deleteCharAt(0);
            }
            int i = sb.length();
            while (i-- > 0) {
                if (Character.isDigit(sb.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

