/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrHexTextField;
import com.sanrad.swing.components.SrMultiTextField;
import com.sanrad.swing.components.SrTextField;

public class SrHexAddressTextField
extends SrMultiTextField {
    private static final int MAX_DIGITS_PER_FIELD = 2;
    private static final int NUM_OF_FIELDS = 8;
    private static final String DELIMITER = ":";

    public SrHexAddressTextField() {
        super(DELIMITER);
        SrTextField[] textFields = new SrHexTextField[8];
        for (int i = 0; i < 8; ++i) {
            SrHexTextField txt = new SrHexTextField(2);
            textFields[i] = txt;
        }
        this.initMultiTextFields(textFields);
    }

    public String getText(String delimiter) {
        String hex = "";
        if (this.isTextSet()) {
            for (int i = 0; i < this.myTextFields.length; ++i) {
                String text = this.myTextFields[i].getText();
                hex = hex + (text.length() == 1 ? "0" + text : text);
                hex = hex + (i < this.myTextFields.length - 1 ? delimiter : "");
            }
        }
        return hex;
    }

    @Override
    public String getText() {
        return this.getText(this.delimiter);
    }

    public String toHexString() {
        return this.getText("");
    }

    @Override
    public boolean isComponentValid() {
        boolean valid = true;
        for (int i = 0; i < this.myTextFields.length; ++i) {
            SrTextField txt = this.myTextFields[i];
            String str = txt.getText();
            if (str != null && str.length() >= 2) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.myTextFields.length];
        for (int i = 0; i < this.myTextFields.length; ++i) {
            int fieldVal = ((SrHexTextField)this.myTextFields[i]).intValue();
            ret[i] = fieldVal < 128 ? (byte)fieldVal : (byte)(fieldVal - 256);
        }
        return ret;
    }
}

