/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.util.SrResourceBundle;
import java.util.Locale;
import javax.swing.JLabel;

public class SrGridTextLabel
extends JLabel {
    private static final String HTML_HEAD = "<html><head><style type=\"text/css\">td {white-space: nowrap}</style></head><body>";
    private static final String HTML_END = "</body></html>";
    private static final String TABLE_END = "</table>";
    private static final String TABLE_ROW = "<tr>";
    private static final String ROW_END = "</tr>";
    private static final String TABLE_CELL = "<td>";
    private static final String CELL_END = "</td>";
    private int myColumnCount;
    private int currentColumn = 0;
    private StringBuilder myBuffer = new StringBuilder();

    public SrGridTextLabel(int aColumnCount) {
        if (aColumnCount < 1) {
            throw new IllegalArgumentException("Number of columns " + aColumnCount + " is not valid");
        }
        this.setFont(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getFontResource(SrDefaultUIBundleKeys.LABEL_FONT));
        this.myColumnCount = aColumnCount;
        this.myBuffer.append(HTML_HEAD);
        this.myBuffer.append("<table>");
        this.setFont(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getFontResource(SrDefaultUIBundleKeys.LABEL_FONT));
    }

    public void addText(String aText) {
        if (this.currentColumn == 0) {
            this.myBuffer.append(TABLE_ROW);
        }
        this.myBuffer.append(TABLE_CELL);
        this.myBuffer.append(aText);
        this.myBuffer.append(CELL_END);
        this.increaseColume();
        this.setText(this.myBuffer.toString() + ROW_END + TABLE_END + HTML_END);
    }

    private void increaseColume() {
        this.currentColumn = (this.currentColumn + 1) % this.myColumnCount;
    }
}

