/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.Util;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class SrFormattedField
extends SrPanel {
    private static final String ARG_REGEX = "\\{\\d+\\}";
    private static final Pattern theSplitPattern = Pattern.compile("\\{\\d+\\}");

    public SrFormattedField(String aFormatString, SrComponent ... aComps) {
        int i;
        Util.validateInputNotNull(aFormatString, "Format string");
        Util.validateInputNotNull(aComps, "Components");
        String[] labelTexts = theSplitPattern.split(aFormatString);
        ArrayList<Integer> argsIndices = new ArrayList<Integer>();
        int index = 0;
        for (i = 0; i < labelTexts.length; ++i) {
            if ((index += labelTexts[i].length()) >= aFormatString.length()) continue;
            int argStart = aFormatString.indexOf(123, index);
            int argEnd = aFormatString.indexOf(125, index);
            index += argEnd - argStart + 1;
            String argStr = aFormatString.substring(argStart + 1, argEnd);
            argsIndices.add(new Integer(argStr));
        }
        this.setLayout(new FlowLayout(0, 0, 10));
        for (i = 0; i < labelTexts.length; ++i) {
            int indexInComps;
            this.add(new SrLabelField(labelTexts[i]));
            if (i >= argsIndices.size() || (indexInComps = ((Integer)argsIndices.get(i)).intValue()) >= aComps.length) continue;
            this.add((Component)((Object)aComps[indexInComps]));
        }
    }
}

